/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.karaf.commands.blobstore;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import org.apache.felix.gogo.commands.Command;
import org.jclouds.blobstore.BlobStore;
import org.jclouds.domain.Location;
import org.jclouds.karaf.commands.blobstore.BlobStoreCommandWithOptions;

@Command(scope="jclouds", name="blobstore-location-list", description="List all location names")
public class LocationListCommand
extends BlobStoreCommandWithOptions {
    protected Object doExecute() throws Exception {
        BlobStore blobStore = this.getBlobStore();
        ArrayList locationNames = Lists.newArrayList();
        for (Location loc : blobStore.listAssignableLocations()) {
            locationNames.add(loc.getId());
        }
        Collections.sort(locationNames);
        for (String locationName : locationNames) {
            System.out.println(locationName);
        }
        return null;
    }
}

