/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.karaf.commands.blobstore;

import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.Map;
import org.apache.felix.gogo.commands.Argument;
import org.apache.felix.gogo.commands.Command;
import org.jclouds.blobstore.BlobStore;
import org.jclouds.blobstore.ContainerNotFoundException;
import org.jclouds.blobstore.domain.PageSet;
import org.jclouds.blobstore.domain.StorageMetadata;
import org.jclouds.domain.Location;
import org.jclouds.karaf.commands.blobstore.BlobStoreCommandWithOptions;

@Command(scope="jclouds", name="blobstore-container-metadata", description="Output container metadata")
public class ContainerMetadataCommand
extends BlobStoreCommandWithOptions {
    @Argument(index=0, name="containerName", description="The name of the container", required=true, multiValued=true)
    final Collection<String> containerNames = Lists.newArrayList();

    protected Object doExecute() throws Exception {
        BlobStore blobStore = this.getBlobStore();
        PageSet allContainerMetadata = blobStore.list();
        for (String containerName : this.containerNames) {
            boolean found = false;
            for (StorageMetadata containerMetadata : allContainerMetadata) {
                if (!containerName.equals(containerMetadata.getName())) continue;
                ContainerMetadataCommand.printContainerMetadata(containerMetadata);
                found = true;
                break;
            }
            if (found) continue;
            throw new ContainerNotFoundException(containerName, "while getting container metadata");
        }
        return null;
    }

    private static void printContainerMetadata(StorageMetadata containerMetadata) {
        System.out.println(containerMetadata.getName());
        ContainerMetadataCommand.printMetadata("ETag", containerMetadata.getETag());
        ContainerMetadataCommand.printMetadata("Creation-Date", containerMetadata.getCreationDate());
        ContainerMetadataCommand.printMetadata("Last-Modified", containerMetadata.getLastModified());
        Location location = containerMetadata.getLocation();
        if (location != null) {
            ContainerMetadataCommand.printMetadata("Location", location.getId());
        }
        ContainerMetadataCommand.printMetadata("Provider-ID", containerMetadata.getProviderId());
        ContainerMetadataCommand.printMetadata("URI", containerMetadata.getUri());
        for (Map.Entry entry : containerMetadata.getUserMetadata().entrySet()) {
            ContainerMetadataCommand.printMetadata((String)entry.getKey(), entry.getValue());
        }
        System.out.println("");
    }

    private static void printMetadata(String key, Object value) {
        if (value != null) {
            System.out.println(String.format("    %s: %s", key, value));
        }
    }
}

