/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.karaf.commands.blobstore;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableSet;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.apache.felix.gogo.commands.Option;
import org.apache.felix.service.command.CommandSession;
import org.jclouds.ContextBuilder;
import org.jclouds.blobstore.BlobStore;
import org.jclouds.blobstore.BlobStoreContext;
import org.jclouds.karaf.commands.blobstore.BlobStoreCommandBase;
import org.jclouds.karaf.utils.EnvHelper;
import org.jclouds.karaf.utils.ServiceHelper;
import org.jclouds.logging.log4j.config.Log4JLoggingModule;

public abstract class BlobStoreCommandWithOptions
extends BlobStoreCommandBase {
    @Option(name="--name", description="The service context name. Used to distinct between multiple service of the same provider/api. Only usable in interactive mode.")
    protected String name;
    @Option(name="--provider", description="The provider to use.")
    protected String provider;
    @Option(name="--api", description="The api to use.")
    protected String api;
    @Option(name="--identity", description="The identity to use for creating a blob store.")
    protected String identity;
    @Option(name="--credential", description="The credential to use for a blob store.")
    protected String credential;
    @Option(name="--endpoint", description="The endpoint to use for a blob store.")
    protected String endpoint;
    @Option(name="--properties", description="File with properties.")
    protected String propertiesFile;

    @Override
    public Object execute(CommandSession session) throws Exception {
        this.session = session;
        return this.doExecute();
    }

    @Override
    protected List<BlobStore> getBlobStoreServices() {
        if (this.provider == null && this.api == null) {
            return this.blobStoreServices;
        }
        try {
            return Collections.singletonList(this.getBlobStore());
        }
        catch (Throwable t) {
            return Collections.emptyList();
        }
    }

    protected BlobStore getBlobStore() throws IOException {
        String providerOrApiValue;
        boolean canCreateService;
        String endpointValue;
        String credentialValue;
        String identityValue;
        BlobStore blobStore;
        block12: {
            if (this.name == null && this.provider == null && this.api == null && this.blobStoreServices != null && this.blobStoreServices.size() == 1) {
                return (BlobStore)this.blobStoreServices.get(0);
            }
            blobStore = null;
            if (this.propertiesFile != null) {
                EnvHelper.loadProperties(new File(this.propertiesFile));
            }
            String providerValue = EnvHelper.getBlobStoreProvider(this.provider);
            String apiValue = EnvHelper.getBlobStoreApi(this.api);
            identityValue = EnvHelper.getBlobStoreIdentity(this.identity);
            credentialValue = EnvHelper.getBlobStoreCredential(providerValue, this.credential);
            endpointValue = EnvHelper.getBlobStoreEndpoint(this.endpoint);
            boolean contextNameProvided = !Strings.isNullOrEmpty((String)this.name);
            canCreateService = (!Strings.isNullOrEmpty((String)providerValue) || !Strings.isNullOrEmpty((String)apiValue)) && !Strings.isNullOrEmpty((String)identityValue) && !Strings.isNullOrEmpty((String)credentialValue);
            providerOrApiValue = !Strings.isNullOrEmpty((String)providerValue) ? providerValue : apiValue;
            try {
                blobStore = (BlobStore)ServiceHelper.getService(this.name, providerOrApiValue, this.blobStoreServices);
            }
            catch (Throwable t) {
                if (contextNameProvided) {
                    throw new RuntimeException("Could not find blobstore service with id:" + this.name);
                }
                if (canCreateService) break block12;
                StringBuilder sb = new StringBuilder();
                sb.append("Insufficient information to create blobstore service:\n");
                if (providerOrApiValue == null) {
                    sb.append("Missing provider or api. Please specify the --provider / --api options, set the jclouds.provider / jclouds.api properties, or set the JCLOUDS_BLOBSTORE_PROVIDER / JCLOUDS_BLOBSTORE_API environment variables.\n");
                }
                if (identityValue == null) {
                    sb.append("Missing identity. Please specify the --identity option, set the jclouds.identity property, or set the JCLOUDS_BLOBSTORE_IDENTITY environment variable.\n");
                }
                if (credentialValue == null) {
                    sb.append("Missing credential. Please specify the --credential option, set the jclouds.credential property, or set the JCLOUDS_BLOBSTORE_CREDENTIAL environment variable.\n");
                }
                throw new RuntimeException(sb.toString());
            }
        }
        if (blobStore == null && canCreateService) {
            try {
                ContextBuilder builder = ContextBuilder.newBuilder((String)providerOrApiValue).credentials(identityValue, credentialValue).modules((Iterable)ImmutableSet.of((Object)new Log4JLoggingModule()));
                if (!Strings.isNullOrEmpty((String)endpointValue)) {
                    builder = builder.endpoint(endpointValue);
                }
                BlobStoreContext context = (BlobStoreContext)builder.build(BlobStoreContext.class);
                blobStore = context.getBlobStore();
            }
            catch (Exception ex) {
                throw new RuntimeException("Failed to create service: " + ex.getMessage(), ex);
            }
        }
        return blobStore;
    }
}

