/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.karaf.commands.blobstore;

import com.google.common.base.Charsets;
import com.google.common.io.CharStreams;
import com.google.common.io.FileWriteMode;
import com.google.common.io.Files;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.apache.felix.gogo.commands.Argument;
import org.apache.felix.gogo.commands.Command;
import org.apache.felix.gogo.commands.CommandException;
import org.apache.felix.gogo.commands.Option;
import org.jclouds.blobstore.BlobStore;
import org.jclouds.karaf.commands.blobstore.BlobStoreCommandWithOptions;
import org.jclouds.util.Closeables2;

@Command(scope="jclouds", name="blobstore-read", description="Reads data from the blobstore")
public class BlobReadCommand
extends BlobStoreCommandWithOptions {
    @Argument(index=0, name="containerName", description="The name of the container", required=true, multiValued=false)
    String containerName;
    @Argument(index=1, name="blobName", description="The name of the blob", required=true, multiValued=false)
    String blobName;
    @Argument(index=2, name="toFile", description="The file to store the blob", required=false, multiValued=false)
    String fileName;
    @Option(name="-d", aliases={"--display"}, description="Display the content to the console", required=false, multiValued=false)
    boolean display;
    @Option(name="-S", aliases={"--signed-request"}, description="Use a signed request", required=false, multiValued=false)
    boolean signedRequest;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object doExecute() throws Exception {
        BlobStore blobStore = this.getBlobStore();
        InputStream is = this.getBlobInputStream(blobStore, this.containerName, this.blobName, this.signedRequest);
        try {
            if (this.display) {
                CharStreams.copy((Readable)new InputStreamReader(is, Charsets.UTF_8), (Appendable)System.out);
                System.out.flush();
            } else {
                if (this.fileName == null) {
                    throw new CommandException("Must specify --display or file name");
                }
                File file = new File(this.fileName);
                if (!file.exists() && !file.createNewFile()) {
                    throw new IOException("Could not create: " + file);
                }
                Files.asByteSink((File)file, (FileWriteMode[])new FileWriteMode[0]).writeFrom(is);
            }
        }
        finally {
            Closeables2.closeQuietly((Closeable)is);
        }
        return null;
    }
}

