/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.karaf.commands.blobstore;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import org.apache.felix.gogo.commands.Argument;
import org.apache.felix.gogo.commands.Command;
import org.jclouds.blobstore.BlobStore;
import org.jclouds.blobstore.domain.PageSet;
import org.jclouds.blobstore.domain.StorageMetadata;
import org.jclouds.blobstore.options.ListContainerOptions;
import org.jclouds.karaf.commands.blobstore.BlobStoreCommandWithOptions;

@Command(scope="jclouds", name="blobstore-list", description="Lists blobs in a container")
public class BlobListCommand
extends BlobStoreCommandWithOptions {
    @Argument(index=0, name="containerName", description="The name of the container", required=true)
    String containerName;
    @Argument(index=1, name="directoryPath", description="List blobs only in this directory path", required=false)
    String directoryPath;

    protected Object doExecute() throws Exception {
        BlobStore blobStore = this.getBlobStore();
        ListContainerOptions options = ListContainerOptions.Builder.recursive();
        if (this.directoryPath != null) {
            options = options.inDirectory(this.directoryPath);
        }
        while (true) {
            PageSet blobStoreMetadatas = blobStore.list(this.containerName, options);
            ArrayList blobNames = Lists.newArrayList();
            for (StorageMetadata blobMetadata : blobStoreMetadatas) {
                String blobName = blobMetadata.getName();
                blobNames.add(blobName);
            }
            Collections.sort(blobNames);
            for (String blobName : blobNames) {
                System.out.println(blobName);
            }
            String marker = blobStoreMetadatas.getNextMarker();
            if (marker == null) break;
            options = options.afterMarker(marker);
        }
        return null;
    }
}

