/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.karaf.commands.blobstore;

import org.apache.felix.gogo.commands.Argument;
import org.apache.felix.gogo.commands.Command;
import org.jclouds.blobstore.BlobStore;
import org.jclouds.blobstore.KeyNotFoundException;
import org.jclouds.karaf.commands.blobstore.BlobStoreCommandWithOptions;

@Command(scope="jclouds", name="blobstore-blob-exists", description="Checks existence of blob on the blobstore")
public class BlobExistsCommand
extends BlobStoreCommandWithOptions {
    @Argument(index=0, name="containerName", description="The name of the container", required=true, multiValued=false)
    String containerName;
    @Argument(index=1, name="blobName", description="The name of the blob", required=true, multiValued=false)
    String blobName;

    protected Object doExecute() throws Exception {
        BlobStore blobStore = this.getBlobStore();
        if (!blobStore.blobExists(this.containerName, this.blobName)) {
            throw new KeyNotFoundException(this.containerName, this.blobName, "while checking existence");
        }
        return null;
    }
}

