/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.karaf.chef.services;

import com.google.common.collect.Maps;
import java.util.Hashtable;
import java.util.Map;
import org.jclouds.chef.ChefApi;
import org.jclouds.karaf.chef.core.ChefHelper;
import org.jclouds.karaf.chef.services.ChefRecipeProvider;
import org.jclouds.karaf.chef.services.ChefServiceFactory;
import org.jclouds.karaf.recipe.RecipeProvider;
import org.jclouds.osgi.ApiListener;
import org.jclouds.osgi.ProviderListener;
import org.jclouds.rest.ApiContext;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.cm.ManagedServiceFactory;
import org.osgi.util.tracker.ServiceTracker;

public class Activator
implements BundleActivator {
    private ServiceRegistration chefFactoryRegistration;
    private ChefServiceFactory chefServiceFactory;
    private ServiceTracker chefServiceTracker;
    private Map<String, ServiceRegistration> registrationMap = Maps.newConcurrentMap();

    public void start(BundleContext context) throws Exception {
        this.registerChefServiceFactory(context);
        this.chefServiceTracker = new ServiceTracker(context.getBundle(0L).getBundleContext(), ApiContext.class.getName(), null){

            public Object addingService(ServiceReference reference) {
                Object obj = super.addingService(reference);
                if (ChefHelper.CHEF_TOKEN.isAssignableFrom(obj.getClass())) {
                    String serviceId = String.valueOf(reference.getProperty("service.id"));
                    Activator.this.registerRecipeProviderForService(this.context, serviceId, (ApiContext<ChefApi>)((ApiContext)obj));
                }
                return obj;
            }

            public void removedService(ServiceReference reference, Object service) {
                String serviceId = String.valueOf(reference.getProperty("service.id"));
                Activator.this.unregisterRecipeProviderForService(this.context, serviceId, (ApiContext<ChefApi>)((ApiContext)service));
                super.removedService(reference, service);
            }
        };
        this.chefServiceTracker.open();
    }

    public void stop(BundleContext context) throws Exception {
        if (this.chefFactoryRegistration != null) {
            this.chefFactoryRegistration.unregister();
        }
        if (this.chefServiceTracker != null) {
            this.chefServiceTracker.close();
        }
    }

    private void registerChefServiceFactory(BundleContext context) {
        Hashtable<String, String> properties = new Hashtable<String, String>();
        properties.put("service.pid", "org.jclouds.chef");
        this.chefServiceFactory = new ChefServiceFactory(context);
        this.chefFactoryRegistration = context.registerService(new String[]{ManagedServiceFactory.class.getName(), ProviderListener.class.getName(), ApiListener.class.getName()}, (Object)this.chefServiceFactory, properties);
    }

    private void registerRecipeProviderForService(BundleContext context, String serviceId, ApiContext<ChefApi> chefService) {
        ChefRecipeProvider chefRecipeProvider = new ChefRecipeProvider(chefService);
        ServiceRegistration registration = context.registerService(RecipeProvider.class.getName(), (Object)chefRecipeProvider, null);
        this.registrationMap.put(serviceId, registration);
    }

    private void unregisterRecipeProviderForService(BundleContext context, String serviceId, ApiContext<ChefApi> chefService) {
        if (this.registrationMap.containsKey(serviceId)) {
            ServiceRegistration registration = this.registrationMap.remove(serviceId);
            try {
                registration.unregister();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

