/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.karaf.chef.commands.completer;

import org.apache.karaf.shell.console.Completer;
import org.jclouds.chef.ChefApi;
import org.jclouds.chef.domain.CookbookVersion;
import org.jclouds.karaf.chef.commands.completer.ChefCompleterSupport;
import org.jclouds.karaf.utils.ServiceHelper;
import org.jclouds.rest.ApiContext;

public class CookbookCompleter
extends ChefCompleterSupport
implements Completer {
    public void init() {
        this.cache = this.cacheProvider.getProviderCacheForType("COOKBOOK_CACHE");
    }

    public void updateOnAdded(ApiContext<ChefApi> chefService) {
        Iterable cookbookVersions;
        if (chefService != null && (cookbookVersions = ((ChefApi)chefService.getApi()).chefService().listCookbookVersions()) != null) {
            for (CookbookVersion cookbookVersion : cookbookVersions) {
                for (String cacheKey : ServiceHelper.findCacheKeysForService(chefService)) {
                    this.cache.putAll((Object)cacheKey, cookbookVersion.getMetadata().getProviding().keySet());
                }
            }
        }
    }
}

