/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.karaf.chef.commands.completer;

import java.util.List;
import org.apache.karaf.shell.console.Completer;
import org.apache.karaf.shell.console.completer.StringsCompleter;
import org.jclouds.apis.ApiMetadata;
import org.jclouds.apis.Apis;
import org.jclouds.chef.ChefApi;
import org.jclouds.karaf.chef.core.ChefHelper;
import org.jclouds.rest.ApiContext;

public class ChefApiCompleter
implements Completer {
    private final StringsCompleter delegate = new StringsCompleter();
    private List<ApiContext<ChefApi>> chefServices;
    private final boolean displayApisWithoutService;

    public ChefApiCompleter(boolean displayApisWithoutService) {
        this.displayApisWithoutService = displayApisWithoutService;
    }

    public int complete(String buffer, int cursor, List<String> candidates) {
        try {
            if (this.displayApisWithoutService) {
                for (ApiMetadata apiMetadata : Apis.contextAssignableFrom(ChefHelper.CHEF_TOKEN)) {
                    this.delegate.getStrings().add(apiMetadata.getId());
                }
            } else if (this.chefServices != null) {
                for (ApiContext<ChefApi> ctx : this.chefServices) {
                    String api = ctx.getId();
                    if (Apis.withId((String)api) == null) continue;
                    this.delegate.getStrings().add(api);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.delegate.complete(buffer, cursor, candidates);
    }

    public List<ApiContext<ChefApi>> getChefServices() {
        return this.chefServices;
    }

    public void setChefServices(List<ApiContext<ChefApi>> chefServices) {
        this.chefServices = chefServices;
    }
}

