/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.karaf.chef.commands;

import java.util.Dictionary;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import org.apache.felix.gogo.commands.Command;
import org.apache.felix.gogo.commands.Option;
import org.jclouds.apis.Apis;
import org.jclouds.chef.ChefApi;
import org.jclouds.karaf.chef.commands.ChefCommandWithOptions;
import org.jclouds.karaf.chef.core.ChefHelper;
import org.jclouds.rest.ApiContext;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;

@Command(scope="chef", name="service-create", description="Creates a chef service")
public class ChefServiceCreateCommand
extends ChefCommandWithOptions {
    @Option(name="--add-option", multiValued=true, description="Adds a key value pair to the configuration.")
    protected String[] options;
    @Option(name="--no-wait", multiValued=true, description="Don't wait for compute service registration.")
    protected boolean noWait;
    private BundleContext bundleContext;

    protected Object doExecute() throws Exception {
        if (this.name == null && this.api != null) {
            this.name = this.api;
        }
        Map<String, String> props = this.parseOptions(this.options);
        this.registerChefService(this.configAdmin, this.name, this.api, this.clientName, this.clientKeyFile, this.validatorName, this.validatorKeyFile, this.endpoint, props);
        if (this.noWait) {
            return null;
        }
        if (!this.isApiInstalled(this.api)) {
            System.out.println("Provider / api currently not installed. Service will be created once it does get installed.");
            return null;
        }
        System.out.println(String.format("Waiting for chef service with name: %s.", this.name));
        this.waitForChefService(this.bundleContext, this.name, this.api);
        return null;
    }

    private boolean isApiInstalled(String api) {
        boolean apiFound = false;
        try {
            Apis.withId((String)api);
            apiFound = true;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return apiFound;
    }

    private Map<String, String> parseOptions(String[] options) {
        HashMap<String, String> props = new HashMap<String, String>();
        if (options != null && options.length >= 1) {
            for (String option : options) {
                if (!option.contains("=")) continue;
                String key = option.substring(0, option.indexOf("="));
                String value = option.substring(option.lastIndexOf("=") + 1);
                props.put(key, value);
            }
        }
        return props;
    }

    private void registerChefService(final ConfigurationAdmin configurationAdmin, final String name, final String api, final String clientName, final String clientKeyFile, final String validator, final String validatorKeyFile, final String endpoint, final Map<String, String> props) throws Exception {
        Runnable registrationTask = new Runnable(){

            @Override
            public void run() {
                try {
                    Configuration configuration = ChefServiceCreateCommand.this.findOrCreateFactoryConfiguration(configurationAdmin, "org.jclouds.chef", name, api);
                    if (configuration != null) {
                        Hashtable<String, String> dictionary = configuration.getProperties();
                        if (dictionary == null) {
                            dictionary = new Hashtable<String, String>();
                        }
                        String apiValue = ChefHelper.getChefApi(api);
                        String clientNameValue = ChefHelper.getClientName(clientName);
                        String clientKeyFileValue = ChefHelper.getClientKeyFile(clientKeyFile);
                        String validatorNameValue = ChefHelper.getValidatorName(validator);
                        String validatorKeyFileValue = ChefHelper.getValidatorKeyFile(validatorKeyFile);
                        String endpointValue = ChefHelper.getChefEndpoint(endpoint);
                        if (name != null) {
                            ((Dictionary)dictionary).put("name", name);
                        }
                        if (apiValue != null) {
                            ((Dictionary)dictionary).put("api", apiValue);
                        }
                        if (endpointValue != null) {
                            ((Dictionary)dictionary).put("endpoint", endpointValue);
                        }
                        if (clientNameValue != null) {
                            ((Dictionary)dictionary).put("client.name", clientNameValue);
                        }
                        if (clientKeyFileValue != null) {
                            ((Dictionary)dictionary).put("client.keyFile", clientKeyFileValue);
                        }
                        if (validatorNameValue != null) {
                            ((Dictionary)dictionary).put("validator.name", validatorNameValue);
                        }
                        if (validatorKeyFileValue != null) {
                            ((Dictionary)dictionary).put("validator.keyFile", validatorKeyFileValue);
                        }
                        for (Map.Entry entry : props.entrySet()) {
                            String key = (String)entry.getKey();
                            String value = (String)entry.getValue();
                            ((Dictionary)dictionary).put(key, value);
                        }
                        configuration.update(dictionary);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        };
        new Thread(registrationTask).start();
    }

    public synchronized ApiContext<ChefApi> waitForChefService(BundleContext bundleContext, String name, String api) {
        ApiContext chefService = null;
        try {
            for (int r = 0; r < 6; ++r) {
                ServiceReference[] references = null;
                if (name != null) {
                    references = bundleContext.getAllServiceReferences(ApiContext.class.getName(), "(name=" + name + ")");
                } else if (api != null) {
                    references = bundleContext.getAllServiceReferences(ApiContext.class.getName(), "(api=" + api + ")");
                }
                if (references != null && references.length > 0) {
                    chefService = (ApiContext)bundleContext.getService((ServiceReference)references[0]);
                    return chefService;
                }
                Thread.sleep(10000L);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return chefService;
    }

    public BundleContext getBundleContext() {
        return this.bundleContext;
    }

    public void setBundleContext(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }
}

