/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.ovf;

import org.jclouds.javax.annotation.Nullable;
import org.jclouds.ovf.Section;

public class OperatingSystemSection
extends Section<OperatingSystemSection> {
    protected final Integer id;
    protected final String description;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return OperatingSystemSection.builder().fromOperatingSystemSection(this);
    }

    public OperatingSystemSection(@Nullable Integer id, @Nullable String info, @Nullable String description) {
        super(info);
        this.id = id;
        this.description = description;
    }

    public Integer getId() {
        return this.id;
    }

    public String getDescription() {
        return this.description;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.description == null ? 0 : this.description.hashCode());
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        result = 31 * result + (this.info == null ? 0 : this.info.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OperatingSystemSection other = (OperatingSystemSection)obj;
        if (this.description == null ? other.description != null : !this.description.equals(other.description)) {
            return false;
        }
        if (this.id == null ? other.id != null : !this.id.equals(other.id)) {
            return false;
        }
        return !(this.info == null ? other.info != null : !this.info.equals(other.info));
    }

    @Override
    public String toString() {
        return String.format("[info=%s, id=%s, description=%s]", this.info, this.id, this.description);
    }

    public static class Builder
    extends Section.Builder<OperatingSystemSection> {
        protected Integer id;
        protected String description;

        public Builder id(Integer id) {
            this.id = id;
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            return this;
        }

        public OperatingSystemSection build() {
            return new OperatingSystemSection(this.id, this.info, this.description);
        }

        public Builder fromOperatingSystemSection(OperatingSystemSection in) {
            return this.id(in.getId()).info(in.getInfo()).description(in.getDescription());
        }

        public Builder fromSection(Section<OperatingSystemSection> in) {
            return (Builder)Builder.class.cast(super.fromSection(in));
        }

        public Builder info(String info) {
            return (Builder)Builder.class.cast(super.info(info));
        }
    }
}

