/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.compute.domain.internal;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableSet;
import org.jclouds.compute.domain.ComputeMetadata;
import org.jclouds.domain.Location;
import org.jclouds.domain.LocationScope;

public class NullEqualToIsParentOrIsGrandparentOfCurrentLocation
implements Predicate<ComputeMetadata> {
    private final Supplier<Location> locationSupplier;

    public NullEqualToIsParentOrIsGrandparentOfCurrentLocation(Supplier<Location> locationSupplier) {
        this.locationSupplier = locationSupplier;
    }

    public boolean apply(ComputeMetadata input) {
        Location current = (Location)this.locationSupplier.get();
        if (current == null) {
            return true;
        }
        if (input.getLocation() == null) {
            return true;
        }
        Location parent = current.getParent();
        Preconditions.checkArgument((parent != null || current.getScope() == LocationScope.PROVIDER ? 1 : 0) != 0, (String)"only locations of scope PROVIDER can have a null parent; arg: %s", (Object)current);
        Preconditions.checkState((input.getLocation().getParent() != null || input.getLocation().getScope() == LocationScope.PROVIDER ? 1 : 0) != 0, (String)"only locations of scope PROVIDER can have a null parent; input: %s", (Object)input.getLocation());
        ImmutableSet.Builder predicates = ImmutableSet.builder();
        predicates.add((Object)Predicates.equalTo((Object)current));
        if (parent != null) {
            predicates.add((Object)Predicates.equalTo((Object)parent));
            Location grandparent = parent.getParent();
            if (grandparent != null) {
                predicates.add((Object)Predicates.equalTo((Object)grandparent));
            }
        }
        return Predicates.or((Iterable)predicates.build()).apply((Object)input.getLocation());
    }

    public String toString() {
        return "nullEqualToIsParentOrIsGrandparentOfCurrentLocation()";
    }
}

