/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.compute.strategy;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.compute.domain.Template;
import org.jclouds.domain.Credentials;
import org.jclouds.domain.LoginCredentials;

@Singleton
public class PrioritizeCredentialsFromTemplate {
    private final Function<Template, LoginCredentials> credentialsFromImageOrTemplateOptions;

    @Inject
    public PrioritizeCredentialsFromTemplate(Function<Template, LoginCredentials> credentialsFromImageOrTemplateOptions) {
        this.credentialsFromImageOrTemplateOptions = (Function)Preconditions.checkNotNull(credentialsFromImageOrTemplateOptions, (Object)"credentialsFromImageOrTemplateOptions");
    }

    public LoginCredentials apply(Template template, LoginCredentials fromNode) {
        LoginCredentials creds = fromNode;
        LoginCredentials credsFromParameters = (LoginCredentials)this.credentialsFromImageOrTemplateOptions.apply((Object)template);
        if (credsFromParameters != null) {
            LoginCredentials.Builder builder = LoginCredentials.builder((Credentials)creds);
            if (credsFromParameters.getUser() != null) {
                builder.user(credsFromParameters.getUser());
            }
            if (credsFromParameters.getOptionalPassword().isPresent()) {
                builder.password((String)credsFromParameters.getOptionalPassword().get());
            }
            if (credsFromParameters.getOptionalPrivateKey().isPresent()) {
                builder.privateKey((String)credsFromParameters.getOptionalPrivateKey().get());
            }
            if (credsFromParameters.shouldAuthenticateSudo()) {
                builder.authenticateSudo(true);
            }
            creds = builder.build();
        }
        return creds;
    }
}

