/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.blobstore.binders;

import com.google.common.base.Preconditions;
import jakarta.inject.Singleton;
import org.jclouds.blobstore.domain.Blob;
import org.jclouds.http.HttpRequest;
import org.jclouds.io.Payload;
import org.jclouds.io.payloads.MultipartForm;
import org.jclouds.io.payloads.Part;
import org.jclouds.rest.Binder;

@Singleton
public class BindBlobToMultipartForm
implements Binder {
    public <R extends HttpRequest> R bindToRequest(R request, Object input) {
        Preconditions.checkArgument((boolean)(Preconditions.checkNotNull((Object)input, (Object)"input") instanceof Blob), (Object)"this binder is only valid for Blobs!");
        Preconditions.checkNotNull(request, (Object)"request");
        Blob blob = (Blob)Blob.class.cast(input);
        Part part = Part.create((String)blob.getMetadata().getName(), (Payload)blob.getPayload(), (Part.PartOptions)new Part.PartOptions().contentType(blob.getMetadata().getContentMetadata().getContentType()));
        request.setPayload((Payload)new MultipartForm(new Part[]{part}));
        return request;
    }
}

