/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.blobstore.strategy.internal;

import com.google.common.collect.Ordering;
import com.google.inject.Injector;
import java.io.Closeable;
import java.util.Comparator;
import org.jclouds.ContextBuilder;
import org.jclouds.blobstore.BlobStore;
import org.jclouds.blobstore.domain.Blob;
import org.jclouds.blobstore.domain.PageSet;
import org.jclouds.blobstore.domain.StorageMetadata;
import org.jclouds.blobstore.options.ListContainerOptions;
import org.jclouds.blobstore.strategy.internal.FetchBlobMetadata;
import org.jclouds.util.Closeables2;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

@Test(testName="FetchBlobMetadataTest", singleThreaded=true)
public class FetchBlobMetadataTest {
    private static final String CONTAINER_NAME = "container";
    private BlobStore blobStore;
    private FetchBlobMetadata fetchBlobMetadata;

    @BeforeClass
    public void setupBlobStore() {
        Injector injector = ContextBuilder.newBuilder((String)"transient").buildInjector();
        this.blobStore = (BlobStore)injector.getInstance(BlobStore.class);
        this.fetchBlobMetadata = (FetchBlobMetadata)injector.getInstance(FetchBlobMetadata.class);
        this.fetchBlobMetadata.setContainerName(CONTAINER_NAME);
    }

    @AfterClass
    public void closeBlobSore() {
        if (this.blobStore != null) {
            Closeables2.closeQuietly((Closeable)this.blobStore.getContext());
        }
    }

    @Test
    public void testRetainsOriginalOrder() {
        this.blobStore.createContainerInLocation(null, CONTAINER_NAME);
        for (int blobIndex = 0; blobIndex < 20; ++blobIndex) {
            Blob blob = this.blobStore.blobBuilder("prefix-" + blobIndex).payload("").build();
            this.blobStore.putBlob(CONTAINER_NAME, blob);
        }
        PageSet pageSet = this.blobStore.list(CONTAINER_NAME, ListContainerOptions.Builder.withDetails());
        PageSet resultPageSet = this.fetchBlobMetadata.apply(pageSet);
        Assert.assertNotNull((Object)resultPageSet);
        Assert.assertTrue((boolean)Ordering.from((Comparator)new Comparator<StorageMetadata>(){

            @Override
            public int compare(StorageMetadata o1, StorageMetadata o2) {
                return o1.getName().compareTo(o2.getName());
            }
        }).isOrdered((Iterable)resultPageSet));
    }
}

