/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.blobstore.binders;

import com.google.common.collect.ImmutableMap;
import java.io.File;
import java.util.Map;
import org.jclouds.ContextBuilder;
import org.jclouds.blobstore.binders.BindMapToHeadersWithPrefix;
import org.jclouds.blobstore.binders.BindUserMetadataToHeadersWithPrefix;
import org.jclouds.blobstore.domain.Blob;
import org.jclouds.http.HttpRequest;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"})
public class BindUserMetadataToHeadersWithPrefixTest {
    @Test
    public void testCorrect() throws SecurityException, NoSuchMethodException {
        HttpRequest request = HttpRequest.builder().method("GET").endpoint("http://momma").build();
        BindUserMetadataToHeadersWithPrefix binder = new BindUserMetadataToHeadersWithPrefix(new BindMapToHeadersWithPrefix("prefix:"));
        Blob blob = ((Blob.Factory)ContextBuilder.newBuilder((String)"transient").buildInjector().getInstance(Blob.Factory.class)).create(null);
        blob.getMetadata().setUserMetadata((Map)ImmutableMap.of((Object)"imageName", (Object)"foo", (Object)"serverId", (Object)"2"));
        Assert.assertEquals((Object)binder.bindToRequest(request, (Object)blob), (Object)((HttpRequest.Builder)((HttpRequest.Builder)HttpRequest.builder().method("GET").endpoint("http://momma").addHeader("prefix:imagename", new String[]{"foo"})).addHeader("prefix:serverid", new String[]{"2"})).build());
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void testMustBeBlob() {
        BindUserMetadataToHeadersWithPrefix binder = new BindUserMetadataToHeadersWithPrefix(new BindMapToHeadersWithPrefix("prefix:"));
        HttpRequest request = HttpRequest.builder().method("POST").endpoint("http://localhost").build();
        binder.bindToRequest(request, (Object)new File("foo"));
    }

    @Test(expectedExceptions={NullPointerException.class, IllegalStateException.class})
    public void testNullIsBad() {
        BindUserMetadataToHeadersWithPrefix binder = new BindUserMetadataToHeadersWithPrefix(new BindMapToHeadersWithPrefix("prefix:"));
        HttpRequest request = HttpRequest.builder().method("GET").endpoint("http://momma").build();
        binder.bindToRequest(request, null);
    }
}

