/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.sts;

import jakarta.inject.Named;
import jakarta.ws.rs.FormParam;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import java.io.Closeable;
import org.jclouds.aws.domain.SessionCredentials;
import org.jclouds.aws.filters.FormSigner;
import org.jclouds.aws.xml.SessionCredentialsHandler;
import org.jclouds.rest.annotations.FormParams;
import org.jclouds.rest.annotations.RequestFilters;
import org.jclouds.rest.annotations.VirtualHost;
import org.jclouds.rest.annotations.XMLResponseParser;
import org.jclouds.sts.domain.UserAndSessionCredentials;
import org.jclouds.sts.options.AssumeRoleOptions;
import org.jclouds.sts.options.FederatedUserOptions;
import org.jclouds.sts.options.SessionCredentialsOptions;
import org.jclouds.sts.xml.UserAndSessionCredentialsHandler;

@RequestFilters(value={FormSigner.class})
@VirtualHost
public interface STSApi
extends Closeable {
    @Named(value="GetSessionToken")
    @POST
    @Path(value="/")
    @XMLResponseParser(value=SessionCredentialsHandler.class)
    @FormParams(keys={"Action"}, values={"GetSessionToken"})
    public SessionCredentials createTemporaryCredentials();

    @Named(value="GetSessionToken")
    @POST
    @Path(value="/")
    @XMLResponseParser(value=SessionCredentialsHandler.class)
    @FormParams(keys={"Action"}, values={"GetSessionToken"})
    public SessionCredentials createTemporaryCredentials(SessionCredentialsOptions var1);

    @Named(value="AssumeRole")
    @POST
    @Path(value="/")
    @XMLResponseParser(value=UserAndSessionCredentialsHandler.class)
    @FormParams(keys={"Action"}, values={"AssumeRole"})
    public UserAndSessionCredentials assumeRole(@FormParam(value="RoleArn") String var1, @FormParam(value="RoleSessionName") String var2);

    @Named(value="AssumeRole")
    @POST
    @Path(value="/")
    @XMLResponseParser(value=UserAndSessionCredentialsHandler.class)
    @FormParams(keys={"Action"}, values={"AssumeRole"})
    public UserAndSessionCredentials assumeRole(@FormParam(value="RoleArn") String var1, @FormParam(value="RoleSessionName") String var2, AssumeRoleOptions var3);

    @Named(value="GetFederationToken")
    @POST
    @Path(value="/")
    @XMLResponseParser(value=UserAndSessionCredentialsHandler.class)
    @FormParams(keys={"Action"}, values={"GetFederationToken"})
    public UserAndSessionCredentials createFederatedUser(@FormParam(value="Name") String var1);

    @Named(value="GetFederationToken")
    @POST
    @Path(value="/")
    @XMLResponseParser(value=UserAndSessionCredentialsHandler.class)
    @FormParams(keys={"Action"}, values={"GetFederationToken"})
    public UserAndSessionCredentials createFederatedUser(@FormParam(value="Name") String var1, FederatedUserOptions var2);
}

