/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.sqs.binders;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableTable;
import com.google.common.collect.Maps;
import java.util.Map;
import org.jclouds.aws.binders.BindTableToIndexedFormParams;
import org.jclouds.http.HttpRequest;
import org.jclouds.rest.MapBinder;

public class BindChangeMessageVisibilityBatchRequestEntryToIndexedFormParams
extends BindTableToIndexedFormParams
implements MapBinder {
    protected BindChangeMessageVisibilityBatchRequestEntryToIndexedFormParams() {
        super("ChangeMessageVisibilityBatchRequestEntry.%d.Id", "ChangeMessageVisibilityBatchRequestEntry.%d.ReceiptHandle", "ChangeMessageVisibilityBatchRequestEntry.%d.VisibilityTimeout");
    }

    public Map<String, String> idReceiptHandle(Iterable<String> input) {
        return Maps.uniqueIndex(input, (Function)new Function<String, String>(){
            int index = 1;

            public String apply(String input) {
                return this.index++ + "";
            }
        });
    }

    public <R extends HttpRequest> R bindToRequest(R request, Map<String, Object> postParams) {
        Map<String, String> idReceiptHandle = (Map<String, String>)postParams.get("idReceiptHandle");
        if (idReceiptHandle == null) {
            idReceiptHandle = this.idReceiptHandle((Iterable)postParams.get("receiptHandles"));
        }
        int visibilityTimeout = (Integer)postParams.get("visibilityTimeout");
        ImmutableTable.Builder builder = ImmutableTable.builder();
        for (Map.Entry<String, String> entry : idReceiptHandle.entrySet()) {
            builder.put((Object)entry.getKey(), (Object)entry.getValue(), (Object)visibilityTimeout);
        }
        return (R)this.bindToRequest(request, builder.build());
    }
}

