/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.s3.options;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.util.Date;
import java.util.Map;
import org.jclouds.date.DateService;
import org.jclouds.date.internal.SimpleDateFormatDateService;
import org.jclouds.http.options.BaseHttpRequestOptions;
import org.jclouds.s3.domain.CannedAccessPolicy;

public class CopyObjectOptions
extends BaseHttpRequestOptions {
    private static final DateService dateService = new SimpleDateFormatDateService();
    public static final CopyObjectOptions NONE = new CopyObjectOptions();
    private String cacheControl;
    private String contentDisposition;
    private String contentEncoding;
    private String contentLanguage;
    private String contentType;
    private Map<String, String> metadata;
    private CannedAccessPolicy acl = CannedAccessPolicy.PRIVATE;
    private String metadataPrefix;
    private String headerTag;

    @Inject
    public void setMetadataPrefix(@Named(value="jclouds.blobstore.metaprefix") String metadataPrefix) {
        this.metadataPrefix = metadataPrefix;
    }

    @Inject
    public void setHeaderTag(@Named(value="jclouds.aws.header.tag") String headerTag) {
        this.headerTag = headerTag;
    }

    public CopyObjectOptions overrideAcl(CannedAccessPolicy acl) {
        this.acl = (CannedAccessPolicy)((Object)Preconditions.checkNotNull((Object)((Object)acl), (Object)"acl"));
        if (!acl.equals((Object)CannedAccessPolicy.PRIVATE)) {
            this.replaceHeader("x-amz-acl", acl.toString());
        }
        return this;
    }

    public CannedAccessPolicy getAcl() {
        return this.acl;
    }

    public String getIfModifiedSince() {
        return this.getFirstHeaderOrNull("x-amz-copy-source-if-modified-since");
    }

    public String getIfUnmodifiedSince() {
        return this.getFirstHeaderOrNull("x-amz-copy-source-if-unmodified-since");
    }

    public String getIfMatch() {
        return this.getFirstHeaderOrNull("x-amz-copy-source-if-match");
    }

    public String getIfNoneMatch() {
        return this.getFirstHeaderOrNull("x-amz-copy-source-if-none-match");
    }

    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    public CopyObjectOptions ifSourceModifiedSince(Date ifModifiedSince) {
        Preconditions.checkState((this.getIfMatch() == null ? 1 : 0) != 0, (Object)"ifETagMatches() is not compatible with ifModifiedSince()");
        Preconditions.checkState((this.getIfUnmodifiedSince() == null ? 1 : 0) != 0, (Object)"ifUnmodifiedSince() is not compatible with ifModifiedSince()");
        this.replaceHeader("x-amz-copy-source-if-modified-since", dateService.rfc822DateFormat((Date)Preconditions.checkNotNull((Object)ifModifiedSince, (Object)"ifModifiedSince")));
        return this;
    }

    public CopyObjectOptions ifSourceUnmodifiedSince(Date ifUnmodifiedSince) {
        Preconditions.checkState((this.getIfNoneMatch() == null ? 1 : 0) != 0, (Object)"ifETagDoesntMatch() is not compatible with ifUnmodifiedSince()");
        Preconditions.checkState((this.getIfModifiedSince() == null ? 1 : 0) != 0, (Object)"ifModifiedSince() is not compatible with ifUnmodifiedSince()");
        this.replaceHeader("x-amz-copy-source-if-unmodified-since", dateService.rfc822DateFormat((Date)Preconditions.checkNotNull((Object)ifUnmodifiedSince, (Object)"ifUnmodifiedSince")));
        return this;
    }

    public CopyObjectOptions ifSourceETagMatches(String eTag) {
        Preconditions.checkState((this.getIfNoneMatch() == null ? 1 : 0) != 0, (Object)"ifETagDoesntMatch() is not compatible with ifETagMatches()");
        Preconditions.checkState((this.getIfModifiedSince() == null ? 1 : 0) != 0, (Object)"ifModifiedSince() is not compatible with ifETagMatches()");
        this.replaceHeader("x-amz-copy-source-if-match", CopyObjectOptions.maybeQuoteETag((String)Preconditions.checkNotNull((Object)eTag, (Object)"eTag")));
        return this;
    }

    public CopyObjectOptions ifSourceETagDoesntMatch(String eTag) {
        Preconditions.checkState((this.getIfMatch() == null ? 1 : 0) != 0, (Object)"ifETagMatches() is not compatible with ifETagDoesntMatch()");
        Preconditions.checkState((this.getIfUnmodifiedSince() == null ? 1 : 0) != 0, (Object)"ifUnmodifiedSince() is not compatible with ifETagDoesntMatch()");
        this.replaceHeader("x-amz-copy-source-if-none-match", CopyObjectOptions.maybeQuoteETag((String)Preconditions.checkNotNull((Object)eTag, (Object)"ifETagDoesntMatch")));
        return this;
    }

    public Multimap<String, String> buildRequestHeaders() {
        Preconditions.checkState((this.headerTag != null ? 1 : 0) != 0, (Object)"headerTag should have been injected!");
        Preconditions.checkState((this.metadataPrefix != null ? 1 : 0) != 0, (Object)"metadataPrefix should have been injected!");
        ImmutableMultimap.Builder returnVal = ImmutableMultimap.builder();
        for (Map.Entry entry : this.headers.entries()) {
            returnVal.put((Object)((String)entry.getKey()).replace("amz", this.headerTag), (Object)((String)entry.getValue()));
        }
        boolean replace = false;
        if (this.cacheControl != null) {
            returnVal.put((Object)"Cache-Control", (Object)this.cacheControl);
            replace = true;
        }
        if (this.contentDisposition != null) {
            returnVal.put((Object)"Content-Disposition", (Object)this.contentDisposition);
            replace = true;
        }
        if (this.contentEncoding != null) {
            returnVal.put((Object)"Content-Encoding", (Object)this.contentEncoding);
            replace = true;
        }
        if (this.contentLanguage != null) {
            returnVal.put((Object)"Content-Language", (Object)this.contentLanguage);
            replace = true;
        }
        if (this.contentType != null) {
            returnVal.put((Object)"Content-Type", (Object)this.contentType);
            replace = true;
        }
        if (this.metadata != null) {
            for (Map.Entry<String, String> entry : this.metadata.entrySet()) {
                String key = entry.getKey();
                returnVal.put((Object)(key.startsWith(this.metadataPrefix) ? key : this.metadataPrefix + key), (Object)entry.getValue());
            }
            replace = true;
        }
        if (replace) {
            returnVal.put((Object)"x-amz-metadata-directive".replace("amz", this.headerTag), (Object)"REPLACE");
        }
        return returnVal.build();
    }

    public CopyObjectOptions cacheControl(String cacheControl) {
        this.cacheControl = (String)Preconditions.checkNotNull((Object)cacheControl, (Object)"cacheControl");
        return this;
    }

    public CopyObjectOptions contentDisposition(String contentDisposition) {
        this.contentDisposition = (String)Preconditions.checkNotNull((Object)contentDisposition, (Object)"contentDisposition");
        return this;
    }

    public CopyObjectOptions contentEncoding(String contentEncoding) {
        this.contentEncoding = (String)Preconditions.checkNotNull((Object)contentEncoding, (Object)"contentEncoding");
        return this;
    }

    public CopyObjectOptions contentLanguage(String contentLanguage) {
        this.contentLanguage = (String)Preconditions.checkNotNull((Object)contentLanguage, (Object)"contentLanguage");
        return this;
    }

    public CopyObjectOptions contentType(String contentType) {
        this.contentType = (String)Preconditions.checkNotNull((Object)contentType, (Object)"contentType");
        return this;
    }

    public CopyObjectOptions overrideMetadataWith(Map<String, String> metadata) {
        Preconditions.checkNotNull(metadata, (Object)"metadata");
        this.metadata = metadata;
        return this;
    }

    private static String maybeQuoteETag(String eTag) {
        if (!eTag.startsWith("\"") && !eTag.endsWith("\"")) {
            eTag = "\"" + eTag + "\"";
        }
        return eTag;
    }

    public static class Builder {
        public static CopyObjectOptions overrideAcl(CannedAccessPolicy acl) {
            CopyObjectOptions options = new CopyObjectOptions();
            return options.overrideAcl(acl);
        }

        public static CopyObjectOptions ifSourceModifiedSince(Date ifModifiedSince) {
            CopyObjectOptions options = new CopyObjectOptions();
            return options.ifSourceModifiedSince(ifModifiedSince);
        }

        public static CopyObjectOptions ifSourceUnmodifiedSince(Date ifUnmodifiedSince) {
            CopyObjectOptions options = new CopyObjectOptions();
            return options.ifSourceUnmodifiedSince(ifUnmodifiedSince);
        }

        public static CopyObjectOptions ifSourceETagMatches(String eTag) {
            CopyObjectOptions options = new CopyObjectOptions();
            return options.ifSourceETagMatches(eTag);
        }

        public static CopyObjectOptions ifSourceETagDoesntMatch(String eTag) {
            CopyObjectOptions options = new CopyObjectOptions();
            return options.ifSourceETagDoesntMatch(eTag);
        }

        public static CopyObjectOptions cacheControl(String cacheControl) {
            CopyObjectOptions options = new CopyObjectOptions();
            return options.cacheControl(cacheControl);
        }

        public static CopyObjectOptions contentDisposition(String contentDisposition) {
            CopyObjectOptions options = new CopyObjectOptions();
            return options.contentDisposition(contentDisposition);
        }

        public static CopyObjectOptions contentEncoding(String contentEncoding) {
            CopyObjectOptions options = new CopyObjectOptions();
            return options.contentEncoding(contentEncoding);
        }

        public static CopyObjectOptions contentLanguage(String contentLanguage) {
            CopyObjectOptions options = new CopyObjectOptions();
            return options.contentLanguage(contentLanguage);
        }

        public static CopyObjectOptions contentType(String contentType) {
            CopyObjectOptions options = new CopyObjectOptions();
            return options.contentType(contentType);
        }

        public static CopyObjectOptions overrideMetadataWith(Map<String, String> metadata) {
            CopyObjectOptions options = new CopyObjectOptions();
            return options.overrideMetadataWith(metadata);
        }
    }
}

