/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.s3.binders;

import com.google.common.base.Preconditions;
import jakarta.inject.Singleton;
import java.util.Map;
import org.jclouds.http.HttpRequest;
import org.jclouds.io.Payload;
import org.jclouds.io.Payloads;
import org.jclouds.io.payloads.StringPayload;
import org.jclouds.rest.Binder;

@Singleton
public class BindPartIdsAndETagsToRequest
implements Binder {
    public <R extends HttpRequest> R bindToRequest(R request, Object input) {
        Preconditions.checkArgument((boolean)(Preconditions.checkNotNull((Object)input, (Object)"input") instanceof Map), (Object)"this binder is only valid for Map!");
        Preconditions.checkNotNull(request, (Object)"request");
        Map map = (Map)input;
        Preconditions.checkArgument((!map.isEmpty() ? 1 : 0) != 0, (Object)"Please send parts");
        StringBuilder content = new StringBuilder();
        content.append("<CompleteMultipartUpload>");
        for (Map.Entry entry : map.entrySet()) {
            content.append("<Part>");
            content.append("<PartNumber>").append(entry.getKey()).append("</PartNumber>");
            content.append("<ETag>").append((String)entry.getValue()).append("</ETag>");
            content.append("</Part>");
        }
        content.append("</CompleteMultipartUpload>");
        StringPayload payload = Payloads.newStringPayload((String)content.toString());
        payload.getContentMetadata().setContentType("text/xml");
        request.setPayload((Payload)payload);
        return request;
    }
}

