/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.s3.functions;

import com.google.common.base.Functions;
import com.google.common.base.Optional;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableMap;
import com.google.inject.Binder;
import com.google.inject.Guice;
import com.google.inject.Module;
import com.google.inject.Provides;
import java.net.URI;
import java.util.Map;
import org.jclouds.location.Provider;
import org.jclouds.location.Region;
import org.jclouds.location.functions.RegionToEndpointOrProviderIfNull;
import org.jclouds.s3.functions.AssignCorrectHostnameForBucket;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test
public class AssignCorrectHostnameForBucketTest {
    static final RegionToEndpointOrProviderIfNull REGION_TO_ENDPOINT = (RegionToEndpointOrProviderIfNull)Guice.createInjector((Module[])new Module[]{new Module(){

        public void configure(Binder binder) {
            binder.bindConstant().annotatedWith(Provider.class).to("s3");
        }

        @Provides
        @Provider
        Supplier<URI> defaultUri() {
            return Suppliers.ofInstance((Object)URI.create("https://s3.amazonaws.com"));
        }

        @Provides
        @Region
        Supplier<Map<String, Supplier<URI>>> regionToEndpoints() {
            ImmutableMap regionToEndpoint = ImmutableMap.of((Object)"us-standard", this.defaultUri(), (Object)"us-west-1", (Object)Suppliers.ofInstance((Object)URI.create("https://s3-us-west-1.amazonaws.com")));
            return Suppliers.ofInstance((Object)regionToEndpoint);
        }
    }}).getInstance(RegionToEndpointOrProviderIfNull.class);

    public void testWhenNoBucketRegionMappingInCache() {
        AssignCorrectHostnameForBucket fn = new AssignCorrectHostnameForBucket(REGION_TO_ENDPOINT, Functions.forMap((Map)ImmutableMap.of((Object)"bucket", (Object)Optional.absent())));
        Assert.assertEquals((Object)fn.apply((Object)"bucket"), (Object)URI.create("https://s3.amazonaws.com"));
    }

    public void testWhenBucketRegionMappingInCache() {
        AssignCorrectHostnameForBucket fn = new AssignCorrectHostnameForBucket(REGION_TO_ENDPOINT, Functions.forMap((Map)ImmutableMap.of((Object)"bucket", (Object)Optional.of((Object)"us-west-1"))));
        Assert.assertEquals((Object)fn.apply((Object)"bucket"), (Object)URI.create("https://s3-us-west-1.amazonaws.com"));
    }
}

