/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.s3.blobstore;

import com.google.common.base.Supplier;
import com.google.inject.Module;
import org.jclouds.blobstore.internal.BaseBlobSignerExpectTest;
import org.jclouds.date.TimeStamp;
import org.jclouds.http.HttpRequest;
import org.jclouds.rest.ConfiguresHttpApi;
import org.jclouds.s3.S3Client;
import org.jclouds.s3.config.S3HttpApiModule;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="S3BlobSignerExpectTest")
public class S3BlobSignerExpectTest
extends BaseBlobSignerExpectTest {
    public S3BlobSignerExpectTest() {
        this.provider = "s3";
    }

    protected HttpRequest getBlob() {
        return HttpRequest.builder().method("GET").endpoint("http://localhost/container/name").addQueryParam("Expires", new String[]{"1212684799"}).addQueryParam("AWSAccessKeyId", new String[]{"identity"}).addQueryParam("Signature", new String[]{"Z0UqrkQv83rykFxvI3f0dQtxEAM="}).build();
    }

    protected HttpRequest getBlobWithTime() {
        return HttpRequest.builder().method("GET").endpoint("http://localhost/container/name").addQueryParam("Expires", new String[]{"1212683902"}).addQueryParam("AWSAccessKeyId", new String[]{"identity"}).addQueryParam("Signature", new String[]{"Y4Ac4sZfBemGZmgfG78F7IX+IFg="}).build();
    }

    protected HttpRequest getBlobWithOptions() {
        return ((HttpRequest.Builder)((HttpRequest.Builder)((HttpRequest.Builder)HttpRequest.builder().method("GET").endpoint("http://localhost/container/name").addHeader("Range", new String[]{"bytes=0-1"})).addHeader("Date", new String[]{"Thu, 05 Jun 2008 16:38:19 GMT"})).addHeader("Authorization", new String[]{"AWS identity:0uvBv1wEskuhFHYJF/L6kEV9A7o="})).build();
    }

    protected HttpRequest putBlob() {
        return ((HttpRequest.Builder)HttpRequest.builder().method("PUT").endpoint("http://localhost/container/name").addQueryParam("Expires", new String[]{"1212684799"}).addQueryParam("AWSAccessKeyId", new String[]{"identity"}).addQueryParam("Signature", new String[]{"N3+nS6ogzOqgT+YaThFN6RU/+xs="}).addHeader("Expect", new String[]{"100-continue"})).build();
    }

    protected HttpRequest putBlobWithTime() {
        return ((HttpRequest.Builder)HttpRequest.builder().method("PUT").endpoint("http://localhost/container/name").addQueryParam("Expires", new String[]{"1212683902"}).addQueryParam("AWSAccessKeyId", new String[]{"identity"}).addQueryParam("Signature", new String[]{"genkB2vLxe3AWV/bPvRTMqQts7E="}).addHeader("Expect", new String[]{"100-continue"})).build();
    }

    protected HttpRequest removeBlob() {
        return ((HttpRequest.Builder)((HttpRequest.Builder)HttpRequest.builder().method("DELETE").endpoint("http://localhost/container/name").addHeader("Date", new String[]{"Thu, 05 Jun 2008 16:38:19 GMT"})).addHeader("Authorization", new String[]{"AWS identity:4FnyjdX/ULdDMRbVlLNjZfEo9RQ="})).build();
    }

    protected Module createModule() {
        return new TestS3HttpApiModule();
    }

    @ConfiguresHttpApi
    private static final class TestS3HttpApiModule
    extends S3HttpApiModule<S3Client> {
        private TestS3HttpApiModule() {
        }

        protected String provideTimeStamp(@TimeStamp Supplier<String> cache) {
            return "Thu, 05 Jun 2008 16:38:19 GMT";
        }
    }
}

