/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.s3.binders;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.io.File;
import java.util.Map;
import org.jclouds.blobstore.binders.BindMapToHeadersWithPrefix;
import org.jclouds.http.HttpRequest;
import org.jclouds.s3.S3Client;
import org.jclouds.s3.binders.BindObjectMetadataToRequest;
import org.jclouds.s3.domain.ObjectMetadata;
import org.jclouds.s3.domain.ObjectMetadataBuilder;
import org.jclouds.s3.internal.BaseS3ClientTest;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="BindObjectMetadataToRequestTest")
public class BindObjectMetadataToRequestTest
extends BaseS3ClientTest<S3Client> {
    @Test
    public void testPassWithMinimumDetailsAndPayload5GB() {
        ObjectMetadata md = ObjectMetadataBuilder.create().key("foo").build();
        HttpRequest request = HttpRequest.builder().method("POST").endpoint("http://localhost").build();
        BindObjectMetadataToRequest binder = (BindObjectMetadataToRequest)this.injector.getInstance(BindObjectMetadataToRequest.class);
        Assert.assertEquals((Object)binder.bindToRequest(request, (Object)md), (Object)((HttpRequest.Builder)HttpRequest.builder().method("POST").endpoint("http://localhost").addHeader("Content-Type", new String[]{"binary/octet-stream"})).build());
    }

    @Test
    public void testExtendedPropertiesBind() {
        ObjectMetadata md = ObjectMetadataBuilder.create().key("foo").cacheControl("no-cache").userMetadata((Map)ImmutableMap.of((Object)"foo", (Object)"bar")).build();
        HttpRequest request = HttpRequest.builder().method("POST").endpoint("http://localhost").build();
        BindObjectMetadataToRequest binder = (BindObjectMetadataToRequest)this.injector.getInstance(BindObjectMetadataToRequest.class);
        Assert.assertEquals((Object)binder.bindToRequest(request, (Object)md), (Object)((HttpRequest.Builder)HttpRequest.builder().method("POST").endpoint("http://localhost").headers((Multimap)ImmutableMultimap.of((Object)"Cache-Control", (Object)"no-cache", (Object)"x-amz-meta-foo", (Object)"bar", (Object)"Content-Type", (Object)"binary/octet-stream"))).build());
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void testNoKeyIsBad() {
        ObjectMetadata md = ObjectMetadataBuilder.create().build();
        HttpRequest request = HttpRequest.builder().method("POST").endpoint("http://localhost").build();
        BindObjectMetadataToRequest binder = (BindObjectMetadataToRequest)this.injector.getInstance(BindObjectMetadataToRequest.class);
        binder.bindToRequest(request, (Object)md);
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void testMustBeObjectMetadata() {
        HttpRequest request = HttpRequest.builder().method("POST").endpoint("http://localhost").build();
        ((BindObjectMetadataToRequest)this.injector.getInstance(BindObjectMetadataToRequest.class)).bindToRequest(request, (Object)new File("foo"));
    }

    @Test(expectedExceptions={NullPointerException.class, IllegalStateException.class})
    public void testNullIsBad() {
        BindMapToHeadersWithPrefix binder = new BindMapToHeadersWithPrefix("prefix:");
        HttpRequest request = HttpRequest.builder().method("GET").endpoint("http://momma").build();
        binder.bindToRequest(request, null);
    }
}

