/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.s3.binders;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import org.jclouds.http.HttpRequest;
import org.jclouds.io.Payloads;
import org.jclouds.io.payloads.StringPayload;
import org.jclouds.s3.binders.BindIterableAsPayloadToDeleteRequest;
import org.testng.Assert;
import org.testng.annotations.Test;

public class BindIterableAsPayloadToDeleteRequestTest {
    private final BindIterableAsPayloadToDeleteRequest binder = new BindIterableAsPayloadToDeleteRequest();
    private final HttpRequest request = HttpRequest.builder().method("POST").endpoint("http://localhost/").build();

    @Test
    public void testWithASmallSet() {
        HttpRequest result = this.binder.bindToRequest(this.request, (Object)ImmutableSet.of((Object)"key1", (Object)"key2"));
        StringPayload payload = Payloads.newStringPayload((String)"<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<Delete><Object><Key>key1</Key></Object><Object><Key>key2</Key></Object></Delete>");
        payload.getContentMetadata().setContentType("text/xml");
        Assert.assertEquals((Object)result.getPayload(), (Object)payload);
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void testEmptySetThrowsException() {
        this.binder.bindToRequest(this.request, (Object)ImmutableSet.of());
    }

    @Test(expectedExceptions={NullPointerException.class})
    public void testFailsOnNullSet() {
        this.binder.bindToRequest(this.request, null);
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void testExpectedASetInstance() {
        this.binder.bindToRequest(this.request, (Object)ImmutableList.of());
    }
}

