/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.s3.binders;

import java.io.IOException;
import java.io.InputStream;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.functions.BaseHandlerTest;
import org.jclouds.s3.binders.BindACLToXMLPayload;
import org.jclouds.s3.domain.AccessControlList;
import org.jclouds.s3.domain.CanonicalUser;
import org.jclouds.util.Strings2;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="BindBucketLoggingToXmlPayloadTest")
public class BindACLToXMLPayloadTest
extends BaseHandlerTest {
    public void testBindToRequest() throws IOException {
        AccessControlList acl = new AccessControlList();
        acl.setOwner(new CanonicalUser("jnrouvignac", "Jean-No\u00ebl Rouvignac"));
        acl.addPermission((AccessControlList.Grantee)new AccessControlList.EmailAddressGrantee("adrian@jclouds.org"), "FULL_CONTROL");
        String expected = Strings2.toStringAndClose((InputStream)((Object)((Object)this)).getClass().getResourceAsStream("/acl_to_xml.xml"));
        HttpRequest request = HttpRequest.builder().method("GET").endpoint("http://test").build();
        BindACLToXMLPayload binder = new BindACLToXMLPayload();
        binder.bindToRequest(request, (Object)acl);
        Assert.assertEquals((String)request.getPayload().getContentMetadata().getContentType(), (String)"text/xml");
        Assert.assertEquals((Object)request.getPayload().getRawContent(), (Object)expected);
    }
}

