/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.rackspace.cloudidentity.v2_0.domain;

import com.google.common.annotations.Beta;
import com.google.common.base.Optional;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import java.util.Iterator;
import org.jclouds.collect.IterableWithMarker;
import org.jclouds.http.utils.Queries;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.openstack.v2_0.domain.Link;
import org.jclouds.rackspace.cloudidentity.v2_0.options.PaginationOptions;

@Beta
public class PaginatedCollection<T>
extends IterableWithMarker<T> {
    private Iterable<T> resources;
    private Iterable<Link> links;
    private int totalEntries;

    protected PaginatedCollection(@Nullable Iterable<T> resources, @Nullable Iterable<Link> links, int totalEntries) {
        this.resources = resources != null ? resources : ImmutableSet.of();
        this.links = links != null ? links : ImmutableSet.of();
        this.totalEntries = totalEntries;
    }

    public Iterator<T> iterator() {
        return this.resources.iterator();
    }

    public Iterable<Link> getLinks() {
        return this.links;
    }

    public int getTotalEntries() {
        return this.totalEntries;
    }

    public PaginationOptions nextPaginationOptions() {
        return (PaginationOptions)((Object)PaginationOptions.class.cast(this.nextMarker().get()));
    }

    public Optional<Object> nextMarker() {
        for (Link link : this.getLinks()) {
            if (Link.Relation.NEXT != link.getRelation()) continue;
            return Optional.of((Object)this.toPaginationOptions(link));
        }
        return Optional.absent();
    }

    private Object toPaginationOptions(Link link) {
        Multimap queryParams = (Multimap)Queries.queryParser().apply((Object)link.getHref().getRawQuery());
        PaginationOptions paginationOptions = PaginationOptions.Builder.queryParameters((Multimap<String, String>)queryParams);
        return paginationOptions;
    }
}

