/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.rackspace.cloudidentity.v2_0.options;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.Multimap;
import java.util.Collection;
import org.jclouds.rackspace.cloudidentity.v2_0.options.PaginationOptions;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="PaginationOptionsTest")
public class PaginationOptionsTest {
    public void testQueryParameters() {
        ImmutableSetMultimap queryParameters = ImmutableSetMultimap.of((Object)"limit", (Object)"1", (Object)"offset", (Object)"1", (Object)"name", (Object)"foo");
        PaginationOptions options = new PaginationOptions().queryParameters((Multimap)queryParameters);
        Assert.assertEquals((Object)queryParameters, (Object)options.buildQueryParameters());
    }

    public void testMaxResults() {
        int limit = 1;
        PaginationOptions options = new PaginationOptions().limit(limit);
        Assert.assertEquals((Collection)ImmutableList.of((Object)"1"), (Collection)options.buildQueryParameters().get((Object)"limit"));
    }

    public void testOffset() {
        int offset = 1;
        PaginationOptions options = new PaginationOptions().offset(offset);
        Assert.assertEquals((Collection)ImmutableList.of((Object)"1"), (Collection)options.buildQueryParameters().get((Object)"offset"));
    }

    public void testNameFilter() {
        String nameFilter = "foo";
        PaginationOptions options = new PaginationOptions().name(nameFilter);
        Assert.assertEquals((Collection)ImmutableList.of((Object)"foo"), (Collection)options.buildQueryParameters().get((Object)"name"));
    }

    public void testMaxResultsStatic() {
        int limit = 1;
        PaginationOptions options = PaginationOptions.Builder.limit((int)limit);
        Assert.assertEquals((Collection)ImmutableList.of((Object)"1"), (Collection)options.buildQueryParameters().get((Object)"limit"));
    }

    public void testOffsetStatic() {
        int offset = 1;
        PaginationOptions options = PaginationOptions.Builder.offset((int)offset);
        Assert.assertEquals((Collection)ImmutableList.of((Object)"1"), (Collection)options.buildQueryParameters().get((Object)"offset"));
    }

    public void testNameFilterStatic() {
        String nameFilter = "foo";
        PaginationOptions options = PaginationOptions.Builder.name((String)nameFilter);
        Assert.assertEquals((Collection)ImmutableList.of((Object)"foo"), (Collection)options.buildQueryParameters().get((Object)"name"));
    }

    public void testQueryParametersStatic() {
        ImmutableSetMultimap queryParameters = ImmutableSetMultimap.of((Object)"limit", (Object)"1", (Object)"offset", (Object)"1", (Object)"name", (Object)"foo");
        PaginationOptions options = PaginationOptions.Builder.queryParameters((Multimap)queryParameters);
        Assert.assertEquals((Object)queryParameters, (Object)options.buildQueryParameters());
    }
}

