/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.rackspace.clouddns.v1.features;

import java.util.Date;
import java.util.List;
import java.util.Set;
import javax.inject.Named;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import org.jclouds.Fallbacks;
import org.jclouds.collect.PagedIterable;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.openstack.keystone.auth.filters.AuthenticateRequest;
import org.jclouds.openstack.keystone.v2_0.KeystoneFallbacks;
import org.jclouds.openstack.v2_0.domain.PaginatedCollection;
import org.jclouds.openstack.v2_0.options.PaginationOptions;
import org.jclouds.rackspace.clouddns.v1.binders.FormatAndContentsToJSON;
import org.jclouds.rackspace.clouddns.v1.binders.UpdateDomainsToJSON;
import org.jclouds.rackspace.clouddns.v1.config.CloudDNS;
import org.jclouds.rackspace.clouddns.v1.domain.CreateDomain;
import org.jclouds.rackspace.clouddns.v1.domain.Domain;
import org.jclouds.rackspace.clouddns.v1.domain.DomainChange;
import org.jclouds.rackspace.clouddns.v1.domain.Job;
import org.jclouds.rackspace.clouddns.v1.domain.Subdomain;
import org.jclouds.rackspace.clouddns.v1.domain.UpdateDomain;
import org.jclouds.rackspace.clouddns.v1.functions.DomainsToPagedIterable;
import org.jclouds.rackspace.clouddns.v1.functions.ParseDomain;
import org.jclouds.rackspace.clouddns.v1.functions.ParseDomains;
import org.jclouds.rackspace.clouddns.v1.functions.ParseJob;
import org.jclouds.rackspace.clouddns.v1.functions.ParseSubdomains;
import org.jclouds.rackspace.clouddns.v1.functions.SubdomainsToPagedIterable;
import org.jclouds.rackspace.cloudidentity.v2_0.functions.DateParser;
import org.jclouds.rest.annotations.BinderParam;
import org.jclouds.rest.annotations.Endpoint;
import org.jclouds.rest.annotations.Fallback;
import org.jclouds.rest.annotations.MapBinder;
import org.jclouds.rest.annotations.ParamParser;
import org.jclouds.rest.annotations.PayloadParam;
import org.jclouds.rest.annotations.QueryParams;
import org.jclouds.rest.annotations.RequestFilters;
import org.jclouds.rest.annotations.ResponseParser;
import org.jclouds.rest.annotations.Transform;
import org.jclouds.rest.annotations.WrapWith;
import org.jclouds.rest.binders.BindToJsonPayload;

@Endpoint(value=CloudDNS.class)
@RequestFilters(value={AuthenticateRequest.class})
public interface DomainApi {
    @Named(value="domain:create")
    @POST
    @Consumes(value={"application/json"})
    @ResponseParser(value=ParseJob.class)
    @Path(value="/domains")
    public Job<Set<Domain>> create(@WrapWith(value="domains") Iterable<CreateDomain> var1);

    @Named(value="domain:list")
    @GET
    @Consumes(value={"application/json"})
    @ResponseParser(value=ParseDomains.class)
    @Transform(value=DomainsToPagedIterable.class)
    @Path(value="/domains")
    @Fallback(value=Fallbacks.EmptyPagedIterableOnNotFoundOr404.class)
    public PagedIterable<Domain> list();

    @Named(value="domain:list")
    @GET
    @Consumes(value={"application/json"})
    @ResponseParser(value=ParseDomains.class)
    @Transform(value=DomainsToPagedIterable.class)
    @Path(value="/domains")
    @Fallback(value=Fallbacks.EmptyPagedIterableOnNotFoundOr404.class)
    public PagedIterable<Domain> listWithFilterByNamesMatching(@QueryParam(value="name") String var1);

    @Named(value="domain:list")
    @GET
    @ResponseParser(value=ParseDomains.class)
    @Consumes(value={"application/json"})
    @Fallback(value=KeystoneFallbacks.EmptyPaginatedCollectionOnNotFoundOr404.class)
    @Path(value="/domains")
    public PaginatedCollection<Domain> list(PaginationOptions var1);

    @Named(value="domain:list")
    @GET
    @Consumes(value={"application/json"})
    @ResponseParser(value=ParseSubdomains.class)
    @Transform(value=SubdomainsToPagedIterable.class)
    @Path(value="/domains/{domainId}/subdomains")
    @Fallback(value=Fallbacks.EmptyPagedIterableOnNotFoundOr404.class)
    @Nullable
    public PagedIterable<Subdomain> listSubdomains(@PathParam(value="domainId") int var1);

    @Named(value="domain:list")
    @GET
    @ResponseParser(value=ParseSubdomains.class)
    @Consumes(value={"application/json"})
    @Fallback(value=KeystoneFallbacks.EmptyPaginatedCollectionOnNotFoundOr404.class)
    @Path(value="/domains/{domainId}/subdomains")
    public PaginatedCollection<Subdomain> listSubdomains(@PathParam(value="domainId") int var1, PaginationOptions var2);

    @Named(value="domain:list")
    @GET
    @Consumes(value={"application/json"})
    @Path(value="/domains/{id}/changes")
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    @Nullable
    public DomainChange listChanges(@PathParam(value="id") int var1, @ParamParser(value=DateParser.class) @QueryParam(value="changes") Date var2);

    @Named(value="domain:get")
    @GET
    @Consumes(value={"application/json"})
    @Path(value="/domains/{id}")
    @QueryParams(keys={"showRecords", "showSubdomains"}, values={"true", "true"})
    @ResponseParser(value=ParseDomain.class)
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    @Nullable
    public Domain get(@PathParam(value="id") int var1);

    @Named(value="domain:update")
    @PUT
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    @ResponseParser(value=ParseJob.class)
    @Path(value="/domains/{id}")
    public Job<Void> update(@PathParam(value="id") int var1, @BinderParam(value=BindToJsonPayload.class) UpdateDomain var2);

    @Named(value="domain:update")
    @PUT
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    @ResponseParser(value=ParseJob.class)
    @Path(value="/domains")
    @MapBinder(value=UpdateDomainsToJSON.class)
    public Job<Void> updateTTL(@PayloadParam(value="ids") Iterable<Integer> var1, @PayloadParam(value="ttl") int var2);

    @Named(value="domain:update")
    @PUT
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    @ResponseParser(value=ParseJob.class)
    @Path(value="/domains")
    @MapBinder(value=UpdateDomainsToJSON.class)
    public Job<Void> updateEmail(@PayloadParam(value="ids") Iterable<Integer> var1, @PayloadParam(value="emailAddress") String var2);

    @Named(value="domain:delete")
    @DELETE
    @Fallback(value=Fallbacks.VoidOnNotFoundOr404.class)
    @ResponseParser(value=ParseJob.class)
    @Path(value="/domains")
    @Consumes(value={"*/*"})
    public Job<Void> delete(@QueryParam(value="id") Iterable<Integer> var1, @QueryParam(value="deleteSubdomains") boolean var2);

    @Named(value="domain:export")
    @GET
    @Consumes(value={"application/json"})
    @ResponseParser(value=ParseJob.class)
    @Path(value="/domains/{id}/export")
    public Job<List<String>> exportFormat(@PathParam(value="id") int var1, Domain.Format var2);

    @Named(value="domain:import")
    @POST
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    @ResponseParser(value=ParseJob.class)
    @MapBinder(value=FormatAndContentsToJSON.class)
    @Path(value="/domains/import")
    public Job<Domain> importFormat(@PayloadParam(value="contents") List<String> var1, @PayloadParam(value="format") Domain.Format var2);
}

