/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.swift.v1.functions;

import com.google.common.base.Function;
import com.google.common.collect.Multimap;
import com.google.common.hash.HashCode;
import com.google.common.io.BaseEncoding;
import jakarta.inject.Inject;
import java.net.URI;
import java.util.Date;
import org.jclouds.date.DateService;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.HttpResponse;
import org.jclouds.io.MutableContentMetadata;
import org.jclouds.io.Payload;
import org.jclouds.openstack.swift.v1.domain.SwiftObject;
import org.jclouds.openstack.swift.v1.functions.EntriesWithoutMetaPrefix;
import org.jclouds.rest.InvocationContext;
import org.jclouds.rest.internal.GeneratedHttpRequest;

public class ParseObjectFromResponse
implements Function<HttpResponse, SwiftObject>,
InvocationContext<ParseObjectFromResponse> {
    private final DateService dates;
    private String uri;
    private String name;

    @Inject
    ParseObjectFromResponse(DateService dates) {
        this.dates = dates;
    }

    public SwiftObject apply(HttpResponse from) {
        String etag;
        Payload payload = from.getPayload();
        MutableContentMetadata contentMeta = payload.getContentMetadata();
        String deleteAt = from.getFirstHeaderOrNull("X-Delete-At");
        if (deleteAt != null) {
            long fromEpoch = Long.parseLong(from.getFirstHeaderOrNull("X-Delete-At")) * 1000L;
            contentMeta.setExpires(new Date(fromEpoch));
            payload.setContentMetadata(contentMeta);
        }
        if ((etag = from.getFirstHeaderOrNull("ETag")) != null) {
            if (etag.startsWith("\"") && etag.endsWith("\"") && etag.length() > 1) {
                etag = etag.substring(1, etag.length() - 1);
            }
            payload.getContentMetadata().setContentMD5(HashCode.fromBytes((byte[])BaseEncoding.base16().lowerCase().decode((CharSequence)etag)));
        }
        return SwiftObject.builder().uri(URI.create(this.uri)).name(this.name).etag(etag).payload(payload).lastModified(this.dates.rfc822DateParse(from.getFirstHeaderOrNull("Last-Modified"))).headers((Multimap<String, String>)from.getHeaders()).metadata(EntriesWithoutMetaPrefix.INSTANCE.apply((Multimap<String, String>)from.getHeaders())).build();
    }

    public ParseObjectFromResponse setContext(HttpRequest request) {
        this.uri = request.getEndpoint().toString();
        this.name = ((GeneratedHttpRequest)GeneratedHttpRequest.class.cast(request)).getInvocation().getArgs().get(0).toString();
        return this;
    }
}

