/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.swift.v1.blobstore;

import com.google.common.annotations.Beta;
import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Supplier;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.io.ByteSource;
import com.google.common.io.ByteStreams;
import com.google.common.io.Closeables;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.inject.AbstractModule;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.assistedinject.Assisted;
import jakarta.annotation.Resource;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.RandomAccessFile;
import java.lang.reflect.Method;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import org.jclouds.blobstore.BlobStore;
import org.jclouds.blobstore.BlobStoreContext;
import org.jclouds.blobstore.KeyNotFoundException;
import org.jclouds.blobstore.domain.Blob;
import org.jclouds.blobstore.domain.BlobAccess;
import org.jclouds.blobstore.domain.BlobBuilder;
import org.jclouds.blobstore.domain.BlobMetadata;
import org.jclouds.blobstore.domain.ContainerAccess;
import org.jclouds.blobstore.domain.MultipartPart;
import org.jclouds.blobstore.domain.MultipartUpload;
import org.jclouds.blobstore.domain.MutableBlobMetadata;
import org.jclouds.blobstore.domain.PageSet;
import org.jclouds.blobstore.domain.StorageMetadata;
import org.jclouds.blobstore.domain.StorageType;
import org.jclouds.blobstore.domain.internal.BlobBuilderImpl;
import org.jclouds.blobstore.domain.internal.BlobImpl;
import org.jclouds.blobstore.domain.internal.PageSetImpl;
import org.jclouds.blobstore.functions.BlobToHttpGetOptions;
import org.jclouds.blobstore.options.CreateContainerOptions;
import org.jclouds.blobstore.options.GetOptions;
import org.jclouds.blobstore.options.ListContainerOptions;
import org.jclouds.blobstore.options.PutOptions;
import org.jclouds.blobstore.strategy.ClearListStrategy;
import org.jclouds.blobstore.strategy.internal.MultipartUploadSlicingAlgorithm;
import org.jclouds.collect.Memoized;
import org.jclouds.domain.Location;
import org.jclouds.http.options.GetOptions;
import org.jclouds.io.ContentMetadata;
import org.jclouds.io.Payload;
import org.jclouds.io.PayloadSlicer;
import org.jclouds.io.payloads.ByteSourcePayload;
import org.jclouds.location.predicates.LocationPredicates;
import org.jclouds.logging.Logger;
import org.jclouds.openstack.swift.v1.SwiftApi;
import org.jclouds.openstack.swift.v1.blobstore.functions.ToBlobMetadata;
import org.jclouds.openstack.swift.v1.blobstore.functions.ToListContainerOptions;
import org.jclouds.openstack.swift.v1.blobstore.functions.ToResourceMetadata;
import org.jclouds.openstack.swift.v1.domain.Container;
import org.jclouds.openstack.swift.v1.domain.DeleteStaticLargeObjectResponse;
import org.jclouds.openstack.swift.v1.domain.ObjectList;
import org.jclouds.openstack.swift.v1.domain.Segment;
import org.jclouds.openstack.swift.v1.domain.SwiftObject;
import org.jclouds.openstack.swift.v1.features.BulkApi;
import org.jclouds.openstack.swift.v1.features.ObjectApi;
import org.jclouds.openstack.swift.v1.options.CopyOptions;
import org.jclouds.openstack.swift.v1.options.PutOptions;
import org.jclouds.openstack.swift.v1.options.UpdateContainerOptions;
import org.jclouds.util.Closeables2;

public class RegionScopedSwiftBlobStore
implements BlobStore {
    private final BlobStoreContext context;
    private final ClearListStrategy clearList;
    private final SwiftApi api;
    private final Location region;
    private final String regionId;
    private final BlobToHttpGetOptions toGetOptions = new BlobToHttpGetOptions();
    private final ToListContainerOptions toListContainerOptions = new ToListContainerOptions();
    private final ToResourceMetadata toResourceMetadata;
    protected final PayloadSlicer slicer;
    protected final ListeningExecutorService userExecutor;
    @Resource
    protected Logger logger = Logger.NULL;
    private static final org.jclouds.openstack.swift.v1.options.CreateContainerOptions BASIC_CONTAINER = new org.jclouds.openstack.swift.v1.options.CreateContainerOptions();
    private static final org.jclouds.openstack.swift.v1.options.CreateContainerOptions ANYBODY_READ = new org.jclouds.openstack.swift.v1.options.CreateContainerOptions().anybodyRead();
    private final Payload directoryPayload = new ByteSourcePayload(ByteSource.wrap((byte[])new byte[0])){
        {
            this.getContentMetadata().setContentType("application/directory");
        }
    };
    protected final LoadingCache<String, Optional<Container>> containerCache = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<String, Optional<Container>>(){

        public Optional<Container> load(String container) {
            return Optional.fromNullable((Object)RegionScopedSwiftBlobStore.this.api.getContainerApi(RegionScopedSwiftBlobStore.this.regionId).get(container));
        }
    });
    @com.google.inject.Inject(optional=true)
    @Named(value="jclouds.max-retries")
    protected int retryCountLimit = 5;

    @Inject
    protected RegionScopedSwiftBlobStore(Injector baseGraph, BlobStoreContext context, SwiftApi api, @Memoized Supplier<Set<? extends Location>> locations, @Assisted String regionId, PayloadSlicer slicer, @Named(value="jclouds.user-threads") ListeningExecutorService userExecutor) {
        Preconditions.checkNotNull((Object)regionId, (Object)"regionId");
        Optional found = Iterables.tryFind((Iterable)((Iterable)locations.get()), (Predicate)LocationPredicates.idEquals((String)regionId));
        Preconditions.checkArgument((boolean)found.isPresent(), (String)"region %s not in %s", (Object)regionId, (Object)locations.get());
        this.region = (Location)found.get();
        this.regionId = regionId;
        this.slicer = slicer;
        this.toResourceMetadata = new ToResourceMetadata((Location)found.get());
        this.context = context;
        this.api = api;
        this.userExecutor = userExecutor;
        this.clearList = (ClearListStrategy)baseGraph.createChildInjector(new Module[]{new AbstractModule(){

            protected void configure() {
                this.bind(BlobStore.class).toInstance((Object)RegionScopedSwiftBlobStore.this);
            }
        }}).getInstance(ClearListStrategy.class);
    }

    public Set<? extends Location> listAssignableLocations() {
        return ImmutableSet.of((Object)this.region);
    }

    public PageSet<? extends StorageMetadata> list() {
        FluentIterable containers = this.api.getContainerApi(this.regionId).list().transform((Function)this.toResourceMetadata);
        return new PageSetImpl((Iterable)containers, null);
    }

    public boolean containerExists(String container) {
        Container val = this.api.getContainerApi(this.regionId).get(container);
        this.containerCache.put((Object)container, (Object)Optional.fromNullable((Object)val));
        return val != null;
    }

    public boolean createContainerInLocation(Location location, String container) {
        return this.createContainerInLocation(location, container, (CreateContainerOptions)CreateContainerOptions.NONE);
    }

    public boolean createContainerInLocation(Location location, String container, CreateContainerOptions options) {
        Preconditions.checkArgument((location == null || location.equals(this.region) ? 1 : 0) != 0, (String)"location must be null or %s", (Object)this.region);
        boolean containerCreated = this.api.getContainerApi(this.regionId).create(container, options.isPublicRead() ? ANYBODY_READ : BASIC_CONTAINER);
        if (containerCreated) {
            this.containerCache.put((Object)container, (Object)Optional.fromNullable((Object)this.api.getContainerApi(this.regionId).get(container)));
        }
        return containerCreated;
    }

    public ContainerAccess getContainerAccess(String name) {
        Container container = this.api.getContainerApi(this.regionId).get(name);
        if (((Boolean)container.getAnybodyRead().get()).booleanValue()) {
            return ContainerAccess.PUBLIC_READ;
        }
        return ContainerAccess.PRIVATE;
    }

    public void setContainerAccess(String name, ContainerAccess access) {
        UpdateContainerOptions options = new UpdateContainerOptions();
        if (access == ContainerAccess.PUBLIC_READ) {
            options.anybodyRead();
        } else {
            options.headers((Multimap<String, String>)ImmutableMultimap.of((Object)"X-Container-Read", (Object)""));
        }
        this.api.getContainerApi(this.regionId).update(name, options);
    }

    public PageSet<? extends StorageMetadata> list(String container) {
        return this.list(container, (ListContainerOptions)ListContainerOptions.NONE);
    }

    public PageSet<? extends StorageMetadata> list(final String container, ListContainerOptions options) {
        ObjectApi objectApi = this.api.getObjectApi(this.regionId, container);
        ObjectList objects = objectApi.list(this.toListContainerOptions.apply(options));
        if (objects == null) {
            this.containerCache.put((Object)container, (Object)Optional.absent());
            return new PageSetImpl((Iterable)ImmutableList.of(), null);
        }
        this.containerCache.put((Object)container, (Object)Optional.of((Object)objects.getContainer()));
        List list = Lists.transform((List)((Object)objects), this.toBlobMetadata(container));
        int limit = (Integer)Optional.fromNullable((Object)options.getMaxResults()).or((Object)10000);
        String marker = null;
        if (!list.isEmpty() && list.size() == limit) {
            marker = ((StorageMetadata)list.get(limit - 1)).getName();
        }
        if (options.isDetailed()) {
            list = Lists.transform((List)list, (Function)new Function<StorageMetadata, StorageMetadata>(){

                public StorageMetadata apply(StorageMetadata input) {
                    if (input.getType() != StorageType.BLOB) {
                        return input;
                    }
                    return RegionScopedSwiftBlobStore.this.blobMetadata(container, input.getName());
                }
            });
        }
        return new PageSetImpl((Iterable)list, marker);
    }

    public boolean blobExists(String container, String name) {
        return this.blobMetadata(container, name) != null;
    }

    public String putBlob(String container, Blob blob) {
        return this.putBlob(container, blob, (PutOptions)PutOptions.NONE);
    }

    public String putBlob(String container, Blob blob, PutOptions options) {
        if (options.getBlobAccess() != BlobAccess.PRIVATE) {
            throw new UnsupportedOperationException("blob access not supported by swift");
        }
        if (options.isMultipart()) {
            return this.putMultipartBlob(container, blob, options);
        }
        ObjectApi objectApi = this.api.getObjectApi(this.regionId, container);
        return objectApi.put(blob.getMetadata().getName(), blob.getPayload(), PutOptions.Builder.metadata(blob.getMetadata().getUserMetadata()));
    }

    public String copyBlob(String fromContainer, String fromName, String toContainer, String toName, org.jclouds.blobstore.options.CopyOptions options) {
        ObjectApi objectApi = this.api.getObjectApi(this.regionId, toContainer);
        CopyOptions swiftOptions = new CopyOptions();
        if (options.ifMatch() != null) {
            swiftOptions.ifMatch(options.ifMatch());
        }
        if (options.ifNoneMatch() != null) {
            throw new UnsupportedOperationException("Swift does not support ifNoneMatch");
        }
        if (options.ifModifiedSince() != null) {
            swiftOptions.ifModifiedSince(options.ifModifiedSince());
        }
        if (options.ifUnmodifiedSince() != null) {
            swiftOptions.ifUnmodifiedSince(options.ifUnmodifiedSince());
        }
        HashMap systemMetadata = Maps.newHashMap();
        ContentMetadata contentMetadata = options.contentMetadata();
        Map<String, String> userMetadata = options.userMetadata();
        if (contentMetadata != null || userMetadata != null) {
            if (contentMetadata != null) {
                String contentType;
                String contentLanguage;
                String contentEncoding;
                String contentDisposition = contentMetadata.getContentDisposition();
                if (contentDisposition != null) {
                    systemMetadata.put("Content-Disposition", contentDisposition);
                }
                if ((contentEncoding = contentMetadata.getContentEncoding()) != null) {
                    systemMetadata.put("Content-Encoding", contentEncoding);
                }
                if ((contentLanguage = contentMetadata.getContentLanguage()) != null) {
                    systemMetadata.put("Content-Language", contentLanguage);
                }
                if ((contentType = contentMetadata.getContentType()) != null) {
                    systemMetadata.put("Content-Type", contentType);
                }
            }
            if (userMetadata == null) {
                userMetadata = Maps.newHashMap();
            }
        } else {
            String contentType;
            String contentLanguage;
            String contentEncoding;
            SwiftObject metadata = this.api.getObjectApi(this.regionId, fromContainer).getWithoutBody(fromName);
            if (metadata == null) {
                throw new KeyNotFoundException(fromContainer, fromName, "Swift could not find the specified source key");
            }
            contentMetadata = metadata.getPayload().getContentMetadata();
            String contentDisposition = contentMetadata.getContentDisposition();
            if (contentDisposition != null) {
                systemMetadata.put("Content-Disposition", contentDisposition);
            }
            if ((contentEncoding = contentMetadata.getContentEncoding()) != null) {
                systemMetadata.put("Content-Encoding", contentEncoding);
            }
            if ((contentLanguage = contentMetadata.getContentLanguage()) != null) {
                systemMetadata.put("Content-Language", contentLanguage);
            }
            if ((contentType = contentMetadata.getContentType()) != null) {
                systemMetadata.put("Content-Type", contentType);
            }
            userMetadata = metadata.getMetadata();
        }
        objectApi.copy(toName, fromContainer, fromName, userMetadata, systemMetadata, swiftOptions);
        return objectApi.getWithoutBody(toName).getETag();
    }

    public BlobMetadata blobMetadata(String container, String name) {
        SwiftObject object = this.api.getObjectApi(this.regionId, container).getWithoutBody(name);
        if (object == null) {
            return null;
        }
        return (BlobMetadata)this.toBlobMetadata(container).apply((Object)object);
    }

    public Blob getBlob(String container, String key) {
        return this.getBlob(container, key, GetOptions.NONE);
    }

    public Blob getBlob(String container, String name, GetOptions options) {
        ObjectApi objectApi = this.api.getObjectApi(this.regionId, container);
        SwiftObject object = objectApi.get(name, this.toGetOptions.apply(options));
        if (object == null) {
            return null;
        }
        BlobImpl blob = new BlobImpl((MutableBlobMetadata)this.toBlobMetadata(container).apply((Object)object));
        blob.setPayload(object.getPayload());
        blob.setAllHeaders(object.getHeaders());
        return blob;
    }

    public void removeBlob(String container, String name) {
        DeleteStaticLargeObjectResponse response = this.api.getStaticLargeObjectApi(this.regionId, container).delete(name);
        if (!response.status().equals("200 OK")) {
            this.api.getObjectApi(this.regionId, container).delete(name);
        }
    }

    public void removeBlobs(String container, Iterable<String> names) {
        BulkApi bulkApi = this.api.getBulkApi(this.regionId);
        for (List partition : Iterables.partition(names, (int)1000)) {
            ImmutableList.Builder builder = ImmutableList.builder();
            for (String name : partition) {
                builder.add((Object)(container + "/" + name));
            }
            bulkApi.bulkDelete((Iterable<String>)builder.build());
        }
    }

    public BlobAccess getBlobAccess(String container, String name) {
        return BlobAccess.PRIVATE;
    }

    public void setBlobAccess(String container, String name, BlobAccess access) {
        throw new UnsupportedOperationException("unsupported in swift");
    }

    public BlobStoreContext getContext() {
        return this.context;
    }

    public BlobBuilder blobBuilder(String name) {
        return new BlobBuilderImpl().name(name);
    }

    public boolean directoryExists(String containerName, String directory) {
        return this.api.getObjectApi(this.regionId, containerName).get(directory) != null;
    }

    public void createDirectory(String containerName, String directory) {
        this.api.getObjectApi(this.regionId, containerName).put(directory, this.directoryPayload);
    }

    public void deleteDirectory(String containerName, String directory) {
        this.api.getObjectApi(this.regionId, containerName).delete(directory);
    }

    public long countBlobs(String containerName) {
        Container container = this.api.getContainerApi(this.regionId).get(containerName);
        return container != null && container.getObjectCount() != null ? container.getObjectCount() : 0L;
    }

    public MultipartUpload initiateMultipartUpload(String container, BlobMetadata blobMetadata, PutOptions options) {
        if (options.getBlobAccess() != BlobAccess.PRIVATE) {
            throw new UnsupportedOperationException("blob ACLs not supported in swift");
        }
        return this.initiateMultipartUpload(container, blobMetadata, 0L, options);
    }

    private MultipartUpload initiateMultipartUpload(String container, BlobMetadata blobMetadata, long partSize, PutOptions options) {
        Long contentLength = blobMetadata.getContentMetadata().getContentLength();
        String uploadId = String.format(Locale.ENGLISH, "%s/slo/%.6f/%s/%s", blobMetadata.getName(), (double)System.currentTimeMillis() / 1000.0, contentLength == null ? Long.valueOf(0L) : contentLength, partSize);
        return MultipartUpload.create((String)container, (String)blobMetadata.getName(), (String)uploadId, (BlobMetadata)blobMetadata, (PutOptions)options);
    }

    public void abortMultipartUpload(MultipartUpload mpu) {
        ImmutableList.Builder names = ImmutableList.builder();
        for (MultipartPart part : this.listMultipartUpload(mpu)) {
            names.add((Object)this.getMPUPartName(mpu, part.partNumber()));
        }
        this.removeBlobs(mpu.containerName(), (Iterable<String>)names.build());
    }

    private ImmutableMap<String, String> getContentMetadataForManifest(ContentMetadata contentMetadata) {
        ImmutableMap.Builder mapBuilder = ImmutableMap.builder();
        if (contentMetadata.getContentType() != null) {
            mapBuilder.put((Object)"content-type", (Object)contentMetadata.getContentType());
        }
        if (contentMetadata.getContentDisposition() != null) {
            mapBuilder.put((Object)"content-disposition", (Object)contentMetadata.getContentDisposition());
        }
        if (contentMetadata.getContentEncoding() != null) {
            mapBuilder.put((Object)"content-encoding", (Object)contentMetadata.getContentEncoding());
        }
        if (contentMetadata.getContentLanguage() != null) {
            mapBuilder.put((Object)"content-language", (Object)contentMetadata.getContentLanguage());
        }
        return mapBuilder.build();
    }

    private String getMPUPartName(MultipartUpload mpu, int partNumber) {
        return String.format("%s/%08d", mpu.id(), partNumber);
    }

    public String completeMultipartUpload(MultipartUpload mpu, List<MultipartPart> parts) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (MultipartPart part : parts) {
            String path = mpu.containerName() + "/" + this.getMPUPartName(mpu, part.partNumber());
            builder.add((Object)Segment.builder().path(path).etag(part.partETag()).sizeBytes(part.partSize()).build());
        }
        return this.api.getStaticLargeObjectApi(this.regionId, mpu.containerName()).replaceManifest(mpu.blobName(), (List<Segment>)builder.build(), mpu.blobMetadata().getUserMetadata(), (Map<String, String>)this.getContentMetadataForManifest(mpu.blobMetadata().getContentMetadata()));
    }

    public MultipartPart uploadMultipartPart(MultipartUpload mpu, int partNumber, Payload payload) {
        String partName = this.getMPUPartName(mpu, partNumber);
        String eTag = this.api.getObjectApi(this.regionId, mpu.containerName()).put(partName, payload);
        long partSize = payload.getContentMetadata().getContentLength();
        Date lastModified = null;
        return MultipartPart.create((int)partNumber, (long)partSize, (String)eTag, lastModified);
    }

    public List<MultipartPart> listMultipartUpload(MultipartUpload mpu) {
        ImmutableList.Builder parts = ImmutableList.builder();
        PageSet<? extends StorageMetadata> pageSet = this.list(mpu.containerName(), new ListContainerOptions().prefix(mpu.id() + "/"));
        for (StorageMetadata sm : pageSet) {
            int lastSlash = sm.getName().lastIndexOf(47);
            int partNumber = Integer.parseInt(sm.getName().substring(lastSlash + 1));
            parts.add((Object)MultipartPart.create((int)partNumber, (long)sm.getSize(), (String)sm.getETag(), (Date)sm.getLastModified()));
        }
        return parts.build();
    }

    public List<MultipartUpload> listMultipartUploads(String container) {
        throw new UnsupportedOperationException();
    }

    public long getMinimumMultipartPartSize() {
        return 0x100001L;
    }

    public long getMaximumMultipartPartSize() {
        return 0x140000000L;
    }

    public int getMaximumNumberOfParts() {
        return Integer.MAX_VALUE;
    }

    public void clearContainer(String containerName) {
        this.clearContainer(containerName, ListContainerOptions.Builder.recursive());
    }

    public void clearContainer(String containerName, ListContainerOptions options) {
        this.clearList.execute(containerName, options);
    }

    public void deleteContainer(String container) {
        this.clearContainer(container, ListContainerOptions.Builder.recursive());
        this.api.getContainerApi(this.regionId).deleteIfEmpty(container);
        this.containerCache.invalidate((Object)container);
    }

    public boolean deleteContainerIfEmpty(String container) {
        boolean deleted = this.api.getContainerApi(this.regionId).deleteIfEmpty(container);
        if (deleted) {
            this.containerCache.invalidate((Object)container);
        }
        return deleted;
    }

    protected Function<SwiftObject, MutableBlobMetadata> toBlobMetadata(String container) {
        return new ToBlobMetadata((Container)((Optional)this.containerCache.getUnchecked((Object)container)).get());
    }

    public long countBlobs(String containerName, ListContainerOptions options) {
        throw new UnsupportedOperationException();
    }

    @Beta
    protected String putMultipartBlob(String container, Blob blob, PutOptions overrides) {
        if (overrides.getUseCustomExecutor()) {
            return this.putMultipartBlob(container, blob, overrides, overrides.getCustomExecutor());
        }
        return this.putMultipartBlob(container, blob, overrides, this.userExecutor);
    }

    @Beta
    protected String putMultipartBlob(String container, Blob blob, PutOptions overrides, ListeningExecutorService executor) {
        ArrayList<ListenableFuture> parts = new ArrayList<ListenableFuture>();
        long contentLength = (Long)Preconditions.checkNotNull((Object)blob.getMetadata().getContentMetadata().getContentLength(), (Object)"must provide content-length to use multi-part upload");
        MultipartUploadSlicingAlgorithm algorithm = new MultipartUploadSlicingAlgorithm(this.getMinimumMultipartPartSize(), this.getMaximumMultipartPartSize(), this.getMaximumNumberOfParts());
        long partSize = algorithm.calculateChunkSize(contentLength);
        MultipartUpload mpu = this.initiateMultipartUpload(container, (BlobMetadata)blob.getMetadata(), partSize, overrides);
        int partNumber = 0;
        for (Payload payload : this.slicer.slice(blob.getPayload(), partSize)) {
            BlobUploader b = new BlobUploader(mpu, partNumber++, payload);
            parts.add(executor.submit((Callable)b));
        }
        return this.completeMultipartUpload(mpu, (List)Futures.getUnchecked((Future)Futures.allAsList(parts)));
    }

    @Beta
    public void downloadBlob(String container, String name, File destination) {
        this.downloadBlob(container, name, destination, (ExecutorService)this.userExecutor);
    }

    @Beta
    public void downloadBlob(String container, String name, File destination, ExecutorService executor) {
        ListeningExecutorService listeningExecutor = MoreExecutors.listeningDecorator((ExecutorService)executor);
        RandomAccessFile raf = null;
        File tempFile = new File(destination + "." + UUID.randomUUID());
        try {
            long contentLength = this.api.getObjectApi(this.regionId, container).getWithoutBody(name).getPayload().getContentMetadata().getContentLength();
            raf = new RandomAccessFile(tempFile, "rw");
            raf.seek(contentLength - 1L);
            raf.write(0);
            long partSize = this.getMinimumMultipartPartSize();
            ArrayList<ListenableFuture> results = new ArrayList<ListenableFuture>();
            for (long from = 0L; from < contentLength; from += partSize) {
                long to = from + partSize >= contentLength ? contentLength - 1L : from + partSize - 1L;
                BlobDownloader b = new BlobDownloader(this.regionId, container, name, raf, from, to);
                results.add(listeningExecutor.submit((Callable)b));
            }
            Futures.getUnchecked((Future)Futures.allAsList(results));
            raf.getChannel().force(true);
            raf.getChannel().close();
            raf.close();
            if (destination.exists()) {
                destination.delete();
            }
            if (!tempFile.renameTo(destination)) {
                throw new RuntimeException("Could not move temporary downloaded file to destination " + destination);
            }
            tempFile = null;
        }
        catch (IOException e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                Closeables2.closeQuietly(raf);
                if (tempFile != null) {
                    tempFile.delete();
                }
                throw throwable;
            }
        }
        Closeables2.closeQuietly((Closeable)raf);
        if (tempFile != null) {
            tempFile.delete();
        }
    }

    @Beta
    public InputStream streamBlob(String container, String name) {
        return this.streamBlob(container, name, (ExecutorService)this.userExecutor);
    }

    @Beta
    public InputStream streamBlob(final String container, final String name, ExecutorService executor) {
        PipedInputStream input;
        PipedOutputStream output;
        final ListeningExecutorService listeningExecutor = MoreExecutors.listeningDecorator((ExecutorService)executor);
        try {
            output = new PipedOutputStream();
            input = new PipedInputStream(output, this.getMinimumMultipartPartSize() * 5L > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)this.getMinimumMultipartPartSize() * 5);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        final long contentLength = this.api.getObjectApi(this.regionId, container).getWithoutBody(name).getPayload().getContentMetadata().getContentLength();
        final long partSize = this.getMinimumMultipartPartSize();
        final LinkedBlockingQueue results = new LinkedBlockingQueue();
        listeningExecutor.submit(new Runnable(){

            @Override
            public void run() {
                try {
                    for (long from = 0L; from < contentLength; from += partSize) {
                        RegionScopedSwiftBlobStore.this.logger.debug(Thread.currentThread() + " writing to output", new Object[0]);
                        ListenableFuture result = (ListenableFuture)results.take();
                        if (result == null) {
                            output.close();
                            input.close();
                            throw new RuntimeException("Error downloading file part to stream");
                        }
                        output.write((byte[])result.get());
                    }
                }
                catch (Exception e) {
                    RegionScopedSwiftBlobStore.this.logger.debug(e.toString(), new Object[0]);
                    Closeables2.closeQuietly((Closeable)input);
                    throw new RuntimeException(e);
                }
                finally {
                    Closeables2.closeQuietly((Closeable)output);
                }
            }
        });
        listeningExecutor.submit(new Runnable(){

            @Override
            public void run() {
                for (long from = 0L; from < contentLength; from += partSize) {
                    long to = from + partSize >= contentLength ? contentLength - 1L : from + partSize - 1L;
                    BlobStreamDownloader b = new BlobStreamDownloader(container, name, from, to);
                    results.add(listeningExecutor.submit((Callable)b));
                }
            }
        });
        return input;
    }

    private final class BlobStreamDownloader
    implements Callable<byte[]> {
        String containerName;
        String objectName;
        private final long begin;
        private final long end;

        BlobStreamDownloader(String containerName, String objectName, long begin, long end) {
            this.containerName = containerName;
            this.objectName = objectName;
            this.begin = begin;
            this.end = end;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public byte[] call() {
            IOException lastException = null;
            for (int retry = 0; retry < RegionScopedSwiftBlobStore.this.retryCountLimit; ++retry) {
                try {
                    byte[] downloadedBlock;
                    long time = System.nanoTime();
                    SwiftObject object = RegionScopedSwiftBlobStore.this.api.getObjectApi(RegionScopedSwiftBlobStore.this.regionId, this.containerName).get(this.objectName, GetOptions.Builder.range((long)this.begin, (long)this.end));
                    InputStream is = object.getPayload().openStream();
                    try {
                        downloadedBlock = ByteStreams.toByteArray((InputStream)is);
                    }
                    finally {
                        Closeables.closeQuietly((InputStream)is);
                    }
                    return downloadedBlock;
                }
                catch (IOException e) {
                    RegionScopedSwiftBlobStore.this.logger.debug(e.toString(), new Object[0]);
                    lastException = e;
                    continue;
                }
            }
            throw new RuntimeException("After " + RegionScopedSwiftBlobStore.this.retryCountLimit + " retries: " + lastException);
        }
    }

    private final class BlobDownloader
    implements Callable<Void> {
        String regionId;
        String containerName;
        String objectName;
        private final RandomAccessFile raf;
        private final long begin;
        private final long end;

        BlobDownloader(String regionId, String containerName, String objectName, RandomAccessFile raf, long begin, long end) {
            this.regionId = regionId;
            this.containerName = containerName;
            this.objectName = objectName;
            this.raf = raf;
            this.begin = begin;
            this.end = end;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Void call() {
            IOException lastException = null;
            for (int retry = 0; retry < RegionScopedSwiftBlobStore.this.retryCountLimit; ++retry) {
                block7: {
                    try {
                        byte[] targetArray;
                        SwiftObject object = RegionScopedSwiftBlobStore.this.api.getObjectApi(this.regionId, this.containerName).get(this.objectName, GetOptions.Builder.range((long)this.begin, (long)this.end));
                        InputStream is = object.getPayload().openStream();
                        try {
                            targetArray = ByteStreams.toByteArray((InputStream)is);
                        }
                        finally {
                            Closeables.closeQuietly((InputStream)is);
                        }
                        MappedByteBuffer out = this.raf.getChannel().map(FileChannel.MapMode.READ_WRITE, this.begin, this.end - this.begin + 1L);
                        out.put(targetArray);
                        out.force();
                        if (!System.getProperty("os.name").toLowerCase().contains("windows")) break block7;
                        this.closeDirectBuffer(out);
                    }
                    catch (IOException e) {
                        lastException = e;
                        continue;
                    }
                }
                return null;
            }
            throw new RuntimeException("After " + RegionScopedSwiftBlobStore.this.retryCountLimit + " retries: " + lastException);
        }

        private void closeDirectBuffer(MappedByteBuffer mbb) {
            if (mbb == null || !mbb.isDirect()) {
                return;
            }
            try {
                Method cleaner = mbb.getClass().getMethod("cleaner", new Class[0]);
                cleaner.setAccessible(true);
                Method clean = Class.forName("sun.misc.Cleaner").getMethod("clean", new Class[0]);
                clean.setAccessible(true);
                clean.invoke(cleaner.invoke((Object)mbb, new Object[0]), new Object[0]);
            }
            catch (Exception e) {
                RegionScopedSwiftBlobStore.this.logger.warn(e.toString(), new Object[0]);
            }
        }
    }

    private final class BlobUploader
    implements Callable<MultipartPart> {
        private final MultipartUpload mpu;
        private final int partNumber;
        private final Payload payload;

        BlobUploader(MultipartUpload mpu, int partNumber, Payload payload) {
            this.mpu = mpu;
            this.partNumber = partNumber;
            this.payload = payload;
        }

        @Override
        public MultipartPart call() {
            return RegionScopedSwiftBlobStore.this.uploadMultipartPart(this.mpu, this.partNumber, this.payload);
        }
    }
}

