/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.swift.v1.domain;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.net.URI;
import java.util.Date;
import java.util.Map;
import org.jclouds.io.Payload;

public class SwiftObject
implements Comparable<SwiftObject> {
    private final String name;
    private final URI uri;
    private final String etag;
    private final Date lastModified;
    private final Multimap<String, String> headers;
    private final Map<String, String> metadata;
    private final Payload payload;

    protected SwiftObject(String name, URI uri, String etag, Date lastModified, Multimap<String, String> headers, Map<String, String> metadata, Payload payload) {
        this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"name");
        this.uri = (URI)Preconditions.checkNotNull((Object)uri, (String)"uri of %s", (Object[])new Object[]{uri});
        this.etag = ((String)Preconditions.checkNotNull((Object)etag, (String)"etag of %s", (Object[])new Object[]{name})).replace("\"", "");
        this.lastModified = (Date)Preconditions.checkNotNull((Object)lastModified, (String)"lastModified of %s", (Object[])new Object[]{name});
        this.headers = headers == null ? ImmutableMultimap.of() : (Multimap)Preconditions.checkNotNull(headers, (String)"headers of %s", (Object[])new Object[]{name});
        this.metadata = metadata == null ? ImmutableMap.of() : metadata;
        this.payload = (Payload)Preconditions.checkNotNull((Object)payload, (String)"payload of %s", (Object[])new Object[]{name});
    }

    public String getName() {
        return this.name;
    }

    public URI getUri() {
        return this.uri;
    }

    public String getEtag() {
        return this.etag;
    }

    public String getETag() {
        return this.etag;
    }

    public Date getLastModified() {
        return this.lastModified;
    }

    public Multimap<String, String> getHeaders() {
        return this.headers;
    }

    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    public Payload getPayload() {
        return this.payload;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof SwiftObject) {
            SwiftObject that = (SwiftObject)SwiftObject.class.cast(object);
            return Objects.equal((Object)this.getName(), (Object)that.getName()) && Objects.equal((Object)this.getUri(), (Object)that.getUri()) && Objects.equal((Object)this.getETag(), (Object)that.getETag());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.getName(), this.getUri(), this.getETag()});
    }

    public String toString() {
        return this.string().toString();
    }

    protected Objects.ToStringHelper string() {
        return Objects.toStringHelper((Object)this).add("name", (Object)this.getName()).add("uri", (Object)this.getUri()).add("etag", (Object)this.getETag()).add("lastModified", (Object)this.getLastModified()).add("metadata", this.getMetadata());
    }

    @Override
    public int compareTo(SwiftObject that) {
        if (that == null) {
            return 1;
        }
        if (this == that) {
            return 0;
        }
        return this.getName().compareTo(that.getName());
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return SwiftObject.builder().fromObject(this);
    }

    public static class Builder {
        protected String name;
        protected URI uri;
        protected String etag;
        protected Date lastModified;
        protected Payload payload;
        protected Multimap<String, String> headers = ImmutableMultimap.of();
        protected Map<String, String> metadata = ImmutableMap.of();

        public Builder name(String name) {
            this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"name");
            return this;
        }

        public Builder uri(URI uri) {
            this.uri = (URI)Preconditions.checkNotNull((Object)uri, (Object)"uri");
            return this;
        }

        public Builder etag(String etag) {
            this.etag = etag;
            return this;
        }

        public Builder lastModified(Date lastModified) {
            this.lastModified = lastModified;
            return this;
        }

        public Builder payload(Payload payload) {
            this.payload = payload;
            return this;
        }

        public Builder headers(Multimap<String, String> headers) {
            this.headers = headers;
            return this;
        }

        public Builder metadata(Map<String, String> metadata) {
            ImmutableMap.Builder builder = ImmutableMap.builder();
            for (Map.Entry entry : ((Map)Preconditions.checkNotNull(metadata, (Object)"metadata")).entrySet()) {
                builder.put((Object)((String)entry.getKey()).toLowerCase(), entry.getValue());
            }
            this.metadata = builder.build();
            return this;
        }

        public SwiftObject build() {
            return new SwiftObject(this.name, this.uri, this.etag, this.lastModified, this.headers, this.metadata, this.payload);
        }

        public Builder fromObject(SwiftObject from) {
            return this.name(from.getName()).uri(from.getUri()).etag(from.getETag()).lastModified(from.getLastModified()).headers(from.getHeaders()).metadata(from.getMetadata()).payload(from.getPayload());
        }
    }
}

