/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.swift.v1.blobstore.functions;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import org.jclouds.blobstore.domain.MutableBlobMetadata;
import org.jclouds.blobstore.domain.StorageMetadata;
import org.jclouds.blobstore.domain.StorageType;
import org.jclouds.blobstore.domain.internal.MutableBlobMetadataImpl;
import org.jclouds.blobstore.strategy.IfDirectoryReturnNameStrategy;
import org.jclouds.blobstore.strategy.internal.MarkersIfDirectoryReturnNameStrategy;
import org.jclouds.openstack.swift.v1.domain.Container;
import org.jclouds.openstack.swift.v1.domain.SwiftObject;

public class ToBlobMetadata
implements Function<SwiftObject, MutableBlobMetadata> {
    private final IfDirectoryReturnNameStrategy ifDirectoryReturnName = new MarkersIfDirectoryReturnNameStrategy();
    private final Container container;

    public ToBlobMetadata(Container container) {
        this.container = (Container)Preconditions.checkNotNull((Object)container, (Object)"container");
    }

    public MutableBlobMetadata apply(SwiftObject from) {
        if (from == null) {
            return null;
        }
        MutableBlobMetadataImpl to = new MutableBlobMetadataImpl();
        to.setContainer(this.container.getName());
        if (this.container.getAnybodyRead().isPresent()) {
            to.setPublicUri(from.getUri());
        }
        to.setUri(from.getUri());
        to.setETag(from.getETag());
        to.setName(from.getName());
        to.setLastModified(from.getLastModified());
        to.setContentMetadata(from.getPayload().getContentMetadata());
        to.getContentMetadata().setContentMD5(from.getPayload().getContentMetadata().getContentMD5AsHashCode());
        to.getContentMetadata().setExpires(from.getPayload().getContentMetadata().getExpires());
        to.setUserMetadata(from.getMetadata());
        String directoryName = this.ifDirectoryReturnName.execute((StorageMetadata)to);
        if (directoryName != null) {
            to.setName(directoryName);
            to.setType((Enum)StorageType.RELATIVE_PATH);
        } else {
            to.setType((Enum)StorageType.BLOB);
        }
        return to;
    }

    public String toString() {
        return "ObjectToBlobMetadata(" + this.container + ")";
    }
}

