/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.swift.v1.blobstore;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Supplier;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.io.ByteSource;
import com.google.inject.AbstractModule;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.assistedinject.Assisted;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import org.jclouds.blobstore.BlobStore;
import org.jclouds.blobstore.BlobStoreContext;
import org.jclouds.blobstore.domain.Blob;
import org.jclouds.blobstore.domain.BlobBuilder;
import org.jclouds.blobstore.domain.BlobMetadata;
import org.jclouds.blobstore.domain.MutableBlobMetadata;
import org.jclouds.blobstore.domain.PageSet;
import org.jclouds.blobstore.domain.StorageMetadata;
import org.jclouds.blobstore.domain.StorageType;
import org.jclouds.blobstore.domain.internal.BlobBuilderImpl;
import org.jclouds.blobstore.domain.internal.BlobImpl;
import org.jclouds.blobstore.domain.internal.PageSetImpl;
import org.jclouds.blobstore.functions.BlobToHttpGetOptions;
import org.jclouds.blobstore.options.GetOptions;
import org.jclouds.blobstore.options.ListContainerOptions;
import org.jclouds.blobstore.options.PutOptions;
import org.jclouds.blobstore.strategy.ClearListStrategy;
import org.jclouds.collect.Memoized;
import org.jclouds.domain.Location;
import org.jclouds.io.Payload;
import org.jclouds.io.payloads.ByteSourcePayload;
import org.jclouds.location.predicates.LocationPredicates;
import org.jclouds.openstack.swift.v1.SwiftApi;
import org.jclouds.openstack.swift.v1.blobstore.functions.ToBlobMetadata;
import org.jclouds.openstack.swift.v1.blobstore.functions.ToListContainerOptions;
import org.jclouds.openstack.swift.v1.blobstore.functions.ToResourceMetadata;
import org.jclouds.openstack.swift.v1.domain.Container;
import org.jclouds.openstack.swift.v1.domain.ObjectList;
import org.jclouds.openstack.swift.v1.domain.SwiftObject;
import org.jclouds.openstack.swift.v1.features.ObjectApi;
import org.jclouds.openstack.swift.v1.options.CreateContainerOptions;
import org.jclouds.openstack.swift.v1.options.PutOptions;

public class RegionScopedSwiftBlobStore
implements BlobStore {
    private final BlobStoreContext context;
    private final ClearListStrategy clearList;
    private final SwiftApi api;
    private final Location region;
    private final String regionId;
    private final BlobToHttpGetOptions toGetOptions = new BlobToHttpGetOptions();
    private final ToListContainerOptions toListContainerOptions = new ToListContainerOptions();
    private final ToResourceMetadata toResourceMetadata;
    private static final CreateContainerOptions BASIC_CONTAINER = new CreateContainerOptions();
    private static final CreateContainerOptions ANYBODY_READ = new CreateContainerOptions().anybodyRead();
    private final Payload directoryPayload = new ByteSourcePayload(ByteSource.wrap((byte[])new byte[0])){
        {
            this.getContentMetadata().setContentType("application/directory");
        }
    };
    protected final LoadingCache<String, Optional<Container>> containerCache = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<String, Optional<Container>>(){

        public Optional<Container> load(String container) {
            return Optional.fromNullable((Object)RegionScopedSwiftBlobStore.this.api.getContainerApi(RegionScopedSwiftBlobStore.this.regionId).get(container));
        }
    });

    @Inject
    protected RegionScopedSwiftBlobStore(Injector baseGraph, BlobStoreContext context, SwiftApi api, @Memoized Supplier<Set<? extends Location>> locations, @Assisted String regionId) {
        Preconditions.checkNotNull((Object)regionId, (Object)"regionId");
        Optional found = Iterables.tryFind((Iterable)((Iterable)locations.get()), (Predicate)LocationPredicates.idEquals((String)regionId));
        Preconditions.checkArgument((boolean)found.isPresent(), (String)"region %s not in %s", (Object[])new Object[]{regionId, locations.get()});
        this.region = (Location)found.get();
        this.regionId = regionId;
        this.toResourceMetadata = new ToResourceMetadata((Location)found.get());
        this.context = context;
        this.api = api;
        this.clearList = (ClearListStrategy)baseGraph.createChildInjector(new Module[]{new AbstractModule(){

            protected void configure() {
                this.bind(BlobStore.class).toInstance((Object)RegionScopedSwiftBlobStore.this);
            }
        }}).getInstance(ClearListStrategy.class);
    }

    public Set<? extends Location> listAssignableLocations() {
        return ImmutableSet.of((Object)this.region);
    }

    public PageSet<? extends StorageMetadata> list() {
        FluentIterable containers = this.api.getContainerApi(this.regionId).list().transform((Function)this.toResourceMetadata);
        return new PageSetImpl((Iterable)containers, null);
    }

    public boolean containerExists(String container) {
        Container val = this.api.getContainerApi(this.regionId).get(container);
        this.containerCache.put((Object)container, (Object)Optional.fromNullable((Object)val));
        return val != null;
    }

    public boolean createContainerInLocation(Location location, String container) {
        return this.createContainerInLocation(location, container, (org.jclouds.blobstore.options.CreateContainerOptions)org.jclouds.blobstore.options.CreateContainerOptions.NONE);
    }

    public boolean createContainerInLocation(Location location, String container, org.jclouds.blobstore.options.CreateContainerOptions options) {
        Preconditions.checkArgument((location == null || location.equals(this.region) ? 1 : 0) != 0, (String)"location must be null or %s", (Object[])new Object[]{this.region});
        if (options.isPublicRead()) {
            return this.api.getContainerApi(this.regionId).create(container, ANYBODY_READ);
        }
        return this.api.getContainerApi(this.regionId).create(container, BASIC_CONTAINER);
    }

    public PageSet<? extends StorageMetadata> list(String container) {
        return this.list(container, (ListContainerOptions)ListContainerOptions.NONE);
    }

    public PageSet<? extends StorageMetadata> list(final String container, ListContainerOptions options) {
        String marker;
        ObjectApi objectApi = this.api.getObjectApi(this.regionId, container);
        ObjectList objects = objectApi.list(this.toListContainerOptions.apply(options));
        if (objects == null) {
            this.containerCache.put((Object)container, (Object)Optional.absent());
            return new PageSetImpl((Iterable)ImmutableList.of(), null);
        }
        this.containerCache.put((Object)container, (Object)Optional.of((Object)objects.getContainer()));
        List list = Lists.transform((List)((Object)objects), this.toBlobMetadata(container));
        int limit = (Integer)Optional.fromNullable((Object)options.getMaxResults()).or((Object)10000);
        String string = marker = list.size() == limit ? ((StorageMetadata)list.get(limit - 1)).getName() : null;
        if (options.isDetailed()) {
            list = Lists.transform((List)list, (Function)new Function<StorageMetadata, StorageMetadata>(){

                public StorageMetadata apply(StorageMetadata input) {
                    if (input.getType() != StorageType.BLOB) {
                        return input;
                    }
                    return RegionScopedSwiftBlobStore.this.blobMetadata(container, input.getName());
                }
            });
        }
        return new PageSetImpl((Iterable)list, marker);
    }

    public boolean blobExists(String container, String name) {
        return this.blobMetadata(container, name) != null;
    }

    public String putBlob(String container, Blob blob) {
        return this.putBlob(container, blob, (PutOptions)PutOptions.NONE);
    }

    public String putBlob(String container, Blob blob, PutOptions options) {
        if (options.isMultipart()) {
            throw new UnsupportedOperationException();
        }
        ObjectApi objectApi = this.api.getObjectApi(this.regionId, container);
        return objectApi.put(blob.getMetadata().getName(), blob.getPayload(), PutOptions.Builder.metadata(blob.getMetadata().getUserMetadata()));
    }

    public BlobMetadata blobMetadata(String container, String name) {
        SwiftObject object = this.api.getObjectApi(this.regionId, container).get(name);
        if (object == null) {
            return null;
        }
        return (BlobMetadata)this.toBlobMetadata(container).apply((Object)object);
    }

    public Blob getBlob(String container, String key) {
        return this.getBlob(container, key, GetOptions.NONE);
    }

    public Blob getBlob(String container, String name, GetOptions options) {
        ObjectApi objectApi = this.api.getObjectApi(this.regionId, container);
        SwiftObject object = objectApi.get(name, this.toGetOptions.apply(options));
        if (object == null) {
            return null;
        }
        BlobImpl blob = new BlobImpl((MutableBlobMetadata)this.toBlobMetadata(container).apply((Object)object));
        blob.setPayload(object.getPayload());
        blob.setAllHeaders(object.getHeaders());
        return blob;
    }

    public void removeBlob(String container, String name) {
        this.api.getObjectApi(this.regionId, container).delete(name);
    }

    public BlobStoreContext getContext() {
        return this.context;
    }

    public BlobBuilder blobBuilder(String name) {
        return new BlobBuilderImpl().name(name);
    }

    public boolean directoryExists(String containerName, String directory) {
        return this.api.getObjectApi(this.regionId, containerName).get(directory) != null;
    }

    public void createDirectory(String containerName, String directory) {
        this.api.getObjectApi(this.regionId, containerName).put(directory, this.directoryPayload);
    }

    public void deleteDirectory(String containerName, String directory) {
        this.api.getObjectApi(this.regionId, containerName).delete(directory);
    }

    public long countBlobs(String containerName) {
        Container container = this.api.getContainerApi(this.regionId).get(containerName);
        return container != null ? container.getObjectCount() : 0L;
    }

    public void clearContainer(String containerName) {
        this.clearContainer(containerName, ListContainerOptions.Builder.recursive());
    }

    public void clearContainer(String containerName, ListContainerOptions options) {
        this.clearList.execute(containerName, options);
    }

    public void deleteContainer(String container) {
        this.clearContainer(container, ListContainerOptions.Builder.recursive());
        this.api.getContainerApi(this.regionId).deleteIfEmpty(container);
        this.containerCache.invalidate((Object)container);
    }

    public boolean deleteContainerIfEmpty(String container) {
        boolean deleted = this.api.getContainerApi(this.regionId).deleteIfEmpty(container);
        if (deleted) {
            this.containerCache.invalidate((Object)container);
        }
        return deleted;
    }

    protected Function<SwiftObject, MutableBlobMetadata> toBlobMetadata(String container) {
        return new ToBlobMetadata((Container)((Optional)this.containerCache.getUnchecked((Object)container)).get());
    }

    public long countBlobs(String containerName, ListContainerOptions options) {
        throw new UnsupportedOperationException();
    }
}

