/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.swift.v1.options;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import com.google.common.net.MediaType;
import java.util.Collection;
import java.util.Map;
import org.jclouds.openstack.swift.v1.options.UpdateContainerOptions;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"})
public class UpdateContainerOptionsTest {
    public void testAnybodyRead() {
        UpdateContainerOptions options = new UpdateContainerOptions().anybodyRead();
        Assert.assertEquals((Collection)options.buildRequestHeaders().get((Object)"X-Container-Read"), (Collection)ImmutableList.of((Object)".r:*,.rlistings"));
    }

    public void testAnybodyReadViaHeaders() {
        UpdateContainerOptions options = new UpdateContainerOptions().headers((Multimap)ImmutableMultimap.of((Object)"X-Container-Read", (Object)".r:*,.rlistings"));
        Assert.assertEquals((Collection)options.buildRequestHeaders().get((Object)"X-Container-Read"), (Collection)ImmutableList.of((Object)".r:*,.rlistings"));
    }

    public void testVersionsLocation() {
        UpdateContainerOptions options = new UpdateContainerOptions().versionsLocation("containerWithVersions");
        Assert.assertEquals((Collection)options.buildRequestHeaders().get((Object)"X-Versions-Location"), (Collection)ImmutableList.of((Object)"containerWithVersions"));
    }

    public void testVersionsLocationViaHeaders() {
        UpdateContainerOptions options = new UpdateContainerOptions().headers((Multimap)ImmutableMultimap.of((Object)"X-Versions-Location", (Object)"containerWithVersions"));
        Assert.assertEquals((Collection)options.buildRequestHeaders().get((Object)"X-Versions-Location"), (Collection)ImmutableList.of((Object)"containerWithVersions"));
    }

    public void testMetadata() {
        UpdateContainerOptions options = new UpdateContainerOptions().metadata((Map)ImmutableMap.of((Object)"ApiName", (Object)"swift", (Object)"metaKey2", (Object)"Value2", (Object)"METAKEY3", (Object)"VALUE 3 "));
        Multimap headers = options.buildRequestHeaders();
        Assert.assertEquals((Collection)headers.get((Object)"X-Container-Meta-apiname"), (Collection)ImmutableList.of((Object)"swift"));
        Assert.assertEquals((Collection)headers.get((Object)"X-Container-Meta-metakey2"), (Collection)ImmutableList.of((Object)"Value2"));
        Assert.assertEquals((Collection)headers.get((Object)"X-Container-Meta-metakey3"), (Collection)ImmutableList.of((Object)"VALUE 3 "));
    }

    public void testHeaders() {
        UpdateContainerOptions options = new UpdateContainerOptions().headers((Multimap)ImmutableMultimap.of((Object)"X-Container-Meta-Quota-Bytes", (Object)"5120", (Object)"X-Container-Meta-apiname", (Object)"swift"));
        Multimap headers = options.buildRequestHeaders();
        Assert.assertEquals((Collection)headers.get((Object)"X-Container-Meta-Quota-Bytes"), (Collection)ImmutableList.of((Object)"5120"));
        Assert.assertEquals((Collection)headers.get((Object)"X-Container-Meta-apiname"), (Collection)ImmutableList.of((Object)"swift"));
    }

    public void testStaticWebsiteDirectoryType() {
        MediaType appDir = MediaType.create((String)"application", (String)"directory");
        ImmutableMultimap headers = ImmutableMultimap.of((Object)"X-Container-Meta-Web-Directory-Type", (Object)appDir.toString());
        UpdateContainerOptions options = new UpdateContainerOptions().headers((Multimap)headers);
        Assert.assertEquals((Collection)options.buildRequestHeaders().get((Object)"X-Container-Meta-Web-Directory-Type"), (Collection)ImmutableList.of((Object)appDir.toString()));
    }

    public void testStaticWebsiteIndexPage() {
        ImmutableMultimap headers = ImmutableMultimap.of((Object)"X-Container-Meta-Web-Index", (Object)"index.html");
        UpdateContainerOptions options = new UpdateContainerOptions().headers((Multimap)headers);
        Assert.assertEquals((Collection)options.buildRequestHeaders().get((Object)"X-Container-Meta-Web-Index"), (Collection)ImmutableList.of((Object)"index.html"));
    }

    public void testStaticWebsiteErrorPage() {
        ImmutableMultimap headers = ImmutableMultimap.of((Object)"X-Container-Meta-Web-Error", (Object)"error.html");
        UpdateContainerOptions options = new UpdateContainerOptions().headers((Multimap)headers);
        Assert.assertEquals((Collection)options.buildRequestHeaders().get((Object)"X-Container-Meta-Web-Error"), (Collection)ImmutableList.of((Object)"error.html"));
    }

    public void testEnableStaticWebsiteListings() {
        ImmutableMultimap headers = ImmutableMultimap.of((Object)"X-Container-Meta-Web-Listings", (Object)"true");
        UpdateContainerOptions options = new UpdateContainerOptions().headers((Multimap)headers);
        Assert.assertEquals((Collection)options.buildRequestHeaders().get((Object)"X-Container-Meta-Web-Listings"), (Collection)ImmutableList.of((Object)"true"));
    }

    public void testDiableStaticWebsiteListings() {
        ImmutableMultimap headers = ImmutableMultimap.of((Object)"X-Container-Meta-Web-Listings", (Object)"false");
        UpdateContainerOptions options = new UpdateContainerOptions().headers((Multimap)headers);
        Assert.assertEquals((Collection)options.buildRequestHeaders().get((Object)"X-Container-Meta-Web-Listings"), (Collection)ImmutableList.of((Object)"false"));
    }

    public void testStaticWebsiteListingsCSS() {
        ImmutableMultimap headers = ImmutableMultimap.of((Object)"X-Container-Meta-Web-Listings-CSS", (Object)"listings.css");
        UpdateContainerOptions options = new UpdateContainerOptions().headers((Multimap)headers);
        Assert.assertEquals((Collection)options.buildRequestHeaders().get((Object)"X-Container-Meta-Web-Listings-CSS"), (Collection)ImmutableList.of((Object)"listings.css"));
    }
}

