/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.swift.v1.options;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.Map;
import org.jclouds.openstack.swift.v1.options.CreateContainerOptions;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"})
public class CreateContainerOptionsTest {
    public void testMetadata() {
        CreateContainerOptions options = new CreateContainerOptions().metadata((Map)ImmutableMap.of((Object)"ApiName", (Object)"swift", (Object)"metaKey2", (Object)"Value2", (Object)"METAKEY3", (Object)"VALUE 3 "));
        Multimap headers = options.buildRequestHeaders();
        Assert.assertEquals((Collection)headers.get((Object)"X-Container-Meta-apiname"), (Collection)ImmutableList.of((Object)"swift"));
        Assert.assertEquals((Collection)headers.get((Object)"X-Container-Meta-metakey2"), (Collection)ImmutableList.of((Object)"Value2"));
        Assert.assertEquals((Collection)headers.get((Object)"X-Container-Meta-metakey3"), (Collection)ImmutableList.of((Object)"VALUE 3 "));
    }

    public void testHeaders() {
        CreateContainerOptions options = new CreateContainerOptions().headers((Multimap)ImmutableMultimap.of((Object)"X-Container-Meta-Quota-Bytes", (Object)"5120", (Object)"X-Container-Meta-apiname", (Object)"swift"));
        Multimap headers = options.buildRequestHeaders();
        Assert.assertEquals((Collection)headers.get((Object)"X-Container-Meta-Quota-Bytes"), (Collection)ImmutableList.of((Object)"5120"));
        Assert.assertEquals((Collection)headers.get((Object)"X-Container-Meta-apiname"), (Collection)ImmutableList.of((Object)"swift"));
    }

    public void testAnybodyRead() {
        CreateContainerOptions options = new CreateContainerOptions().headers((Multimap)ImmutableMultimap.of((Object)"X-Container-Read", (Object)".r:*,.rlistings"));
        Assert.assertEquals((Collection)options.buildRequestHeaders().get((Object)"X-Container-Read"), (Collection)ImmutableList.of((Object)".r:*,.rlistings"));
    }

    public void testVersionsLocation() {
        CreateContainerOptions options = new CreateContainerOptions().headers((Multimap)ImmutableMultimap.of((Object)"X-Versions-Location", (Object)"containerWithVersions"));
        Assert.assertEquals((Collection)options.buildRequestHeaders().get((Object)"X-Versions-Location"), (Collection)ImmutableList.of((Object)"containerWithVersions"));
    }
}

