/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.swift.v1.internal;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.util.concurrent.Uninterruptibles;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.jclouds.apis.BaseApiLiveTest;
import org.jclouds.openstack.swift.v1.SwiftApi;
import org.jclouds.openstack.swift.v1.domain.BulkDeleteResponse;
import org.jclouds.openstack.swift.v1.domain.ObjectList;
import org.jclouds.openstack.swift.v1.domain.SwiftObject;
import org.jclouds.openstack.swift.v1.options.ListContainerOptions;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

@Test(groups={"live"}, testName="BaseSwiftApiLiveTest")
public abstract class BaseSwiftApiLiveTest<A extends SwiftApi>
extends BaseApiLiveTest<A> {
    protected Set<String> regions;

    protected BaseSwiftApiLiveTest() {
        this.provider = "openstack-swift";
    }

    @BeforeClass(groups={"live"})
    public void setup() {
        super.setup();
        String providedRegion = System.getProperty("test.jclouds.region");
        this.regions = providedRegion != null ? ImmutableSet.of((Object)providedRegion) : ((SwiftApi)this.api).getConfiguredRegions();
    }

    protected Properties setupProperties() {
        Properties props = super.setupProperties();
        this.setIfTestSystemPropertyPresent(props, "jclouds.keystone.credential-type");
        this.setIfTestSystemPropertyPresent(props, "jclouds.region");
        return props;
    }

    protected void deleteAllObjectsInContainer(String regionId, final String containerName) {
        Uninterruptibles.sleepUninterruptibly((long)10L, (TimeUnit)TimeUnit.SECONDS);
        ObjectList objects = ((SwiftApi)this.api).getObjectApi(regionId, containerName).list(new ListContainerOptions());
        if (objects == null) {
            return;
        }
        List pathsToDelete = Lists.transform((List)objects, (Function)new Function<SwiftObject, String>(){

            public String apply(SwiftObject input) {
                return containerName + "/" + input.getName();
            }
        });
        if (!pathsToDelete.isEmpty()) {
            BulkDeleteResponse response = ((SwiftApi)this.api).getBulkApi(regionId).bulkDelete((Iterable)pathsToDelete);
            Preconditions.checkState((boolean)response.getErrors().isEmpty(), (String)"Errors deleting paths %s: %s", (Object[])new Object[]{pathsToDelete, response});
        }
    }
}

