/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.swift.v1.features;

import com.google.common.base.Charsets;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.io.BaseEncoding;
import com.google.common.io.ByteSource;
import com.squareup.okhttp.mockwebserver.MockResponse;
import com.squareup.okhttp.mockwebserver.MockWebServer;
import com.squareup.okhttp.mockwebserver.RecordedRequest;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Collection;
import java.util.Date;
import java.util.Map;
import java.util.Properties;
import org.jclouds.date.internal.SimpleDateFormatDateService;
import org.jclouds.http.HttpResponseException;
import org.jclouds.http.options.GetOptions;
import org.jclouds.io.Payload;
import org.jclouds.io.Payloads;
import org.jclouds.io.payloads.ByteSourcePayload;
import org.jclouds.openstack.swift.v1.CopyObjectException;
import org.jclouds.openstack.swift.v1.SwiftApi;
import org.jclouds.openstack.swift.v1.domain.ObjectList;
import org.jclouds.openstack.swift.v1.domain.SwiftObject;
import org.jclouds.openstack.swift.v1.features.ContainerApiMockTest;
import org.jclouds.openstack.swift.v1.options.ListContainerOptions;
import org.jclouds.openstack.swift.v1.options.PutOptions;
import org.jclouds.openstack.v2_0.internal.BaseOpenStackMockTest;
import org.jclouds.util.Strings2;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="ObjectApiMockTest")
public class ObjectApiMockTest
extends BaseOpenStackMockTest<SwiftApi> {
    SimpleDateFormatDateService dates = new SimpleDateFormatDateService();
    static final Payload PAYLOAD = Payloads.newByteSourcePayload((ByteSource)ByteSource.wrap((byte[])"swifty".getBytes()));
    private static final Map<String, String> metadata = ImmutableMap.of((Object)"ApiName", (Object)"swift", (Object)"ApiVersion", (Object)"v1.1");

    protected ImmutableList<SwiftObject> parsedObjectsForUrl(String baseUri) {
        baseUri = baseUri + "v1/MossoCloudFS_5bcf396e-39dd-45ff-93a1-712b9aba90a9/myContainer";
        return ImmutableList.of((Object)SwiftObject.builder().name("test_obj_1").uri(URI.create(baseUri + "/test_obj_1")).etag("4281c348eaf83e70ddce0e07221c3d28").payload(ObjectApiMockTest.payload(14L, "application/octet-stream", new Date(1406243553L))).lastModified(this.dates.iso8601DateParse("2009-02-03T05:26:32.612278")).build(), (Object)SwiftObject.builder().name("test_obj_2").uri(URI.create(baseUri + "/test_obj_2")).etag("b039efe731ad111bc1b0ef221c3849d0").payload(ObjectApiMockTest.payload(64L, "application/octet-stream", null)).lastModified(this.dates.iso8601DateParse("2009-02-03T05:26:32.612278")).build(), (Object)SwiftObject.builder().name("test obj 3").uri(URI.create(baseUri + "/test%20obj%203")).etag("0b2e80bd0744d9ebb20484149a57c82e").payload(ObjectApiMockTest.payload(14L, "application/octet-stream", new Date())).lastModified(this.dates.iso8601DateParse("2014-05-20T05:26:32.612278")).build());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testList() throws Exception {
        MockWebServer server = ObjectApiMockTest.mockOpenStackServer();
        server.enqueue(this.addCommonHeaders(new MockResponse().setBody(this.stringFromResource("/access.json"))));
        server.enqueue(this.addCommonHeaders(ContainerApiMockTest.containerResponse().addHeader("X-Container-Read", (Object)".r:*,.rlistings").setBody(this.stringFromResource("/object_list.json"))));
        try {
            SwiftApi api = (SwiftApi)this.api(server.getUrl("/").toString(), "openstack-swift");
            ObjectList objects = api.getObjectApi("DFW", "myContainer").list();
            Assert.assertEquals((Collection)objects, this.parsedObjectsForUrl(server.getUrl("/").toString()));
            Assert.assertEquals((String)objects.getContainer().getName(), (String)"myContainer");
            Assert.assertTrue((boolean)((Boolean)objects.getContainer().getAnybodyRead().get()));
            SwiftObject object1 = (SwiftObject)objects.get(1);
            Assert.assertEquals((byte[])BaseEncoding.base16().lowerCase().decode((CharSequence)object1.getETag()), (byte[])object1.getPayload().getContentMetadata().getContentMD5AsHashCode().asBytes());
            Assert.assertEquals((int)server.getRequestCount(), (int)2);
            this.assertAuthentication(server);
            this.assertRequest(server.takeRequest(), "GET", "/v1/MossoCloudFS_5bcf396e-39dd-45ff-93a1-712b9aba90a9/myContainer");
        }
        finally {
            server.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testListWithOptions() throws Exception {
        MockWebServer server = ObjectApiMockTest.mockOpenStackServer();
        server.enqueue(this.addCommonHeaders(new MockResponse().setBody(this.stringFromResource("/access.json"))));
        server.enqueue(this.addCommonHeaders(ContainerApiMockTest.containerResponse().addHeader("X-Container-Read", (Object)".r:*,.rlistings").setBody(this.stringFromResource("/object_list.json"))));
        try {
            SwiftApi api = (SwiftApi)this.api(server.getUrl("/").toString(), "openstack-swift");
            ObjectList objects = api.getObjectApi("DFW", "myContainer").list(new ListContainerOptions());
            Assert.assertEquals((Collection)objects, this.parsedObjectsForUrl(server.getUrl("/").toString()));
            Assert.assertEquals((String)objects.getContainer().getName(), (String)"myContainer");
            Assert.assertTrue((boolean)((Boolean)objects.getContainer().getAnybodyRead().get()));
            Assert.assertEquals((int)server.getRequestCount(), (int)2);
            this.assertAuthentication(server);
            this.assertRequest(server.takeRequest(), "GET", "/v1/MossoCloudFS_5bcf396e-39dd-45ff-93a1-712b9aba90a9/myContainer");
        }
        finally {
            server.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testListOptions() throws Exception {
        MockWebServer server = ObjectApiMockTest.mockOpenStackServer();
        server.enqueue(this.addCommonHeaders(new MockResponse().setBody(this.stringFromResource("/access.json"))));
        server.enqueue(this.addCommonHeaders(ContainerApiMockTest.containerResponse().setBody(this.stringFromResource("/object_list.json"))));
        try {
            SwiftApi api = (SwiftApi)this.api(server.getUrl("/").toString(), "openstack-swift");
            ObjectList objects = api.getObjectApi("DFW", "myContainer").list(ListContainerOptions.Builder.marker((String)"test"));
            Assert.assertEquals((Collection)objects, this.parsedObjectsForUrl(server.getUrl("/").toString()));
            Assert.assertEquals((int)server.getRequestCount(), (int)2);
            this.assertAuthentication(server);
            this.assertRequest(server.takeRequest(), "GET", "/v1/MossoCloudFS_5bcf396e-39dd-45ff-93a1-712b9aba90a9/myContainer?marker=test");
        }
        finally {
            server.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testCreate() throws Exception {
        MockWebServer server = ObjectApiMockTest.mockOpenStackServer();
        server.enqueue(this.addCommonHeaders(new MockResponse().setBody(this.stringFromResource("/access.json"))));
        server.enqueue(this.addCommonHeaders(new MockResponse().setResponseCode(201).addHeader("ETag", (Object)"d9f5eb4bba4e2f2f046e54611bc8196b")).addHeader("Expires", (Object)"1406243553"));
        try {
            SwiftApi api = (SwiftApi)this.api(server.getUrl("/").toString(), "openstack-swift");
            Assert.assertEquals((String)api.getObjectApi("DFW", "myContainer").put("myObject", PAYLOAD, PutOptions.Builder.metadata(metadata)), (String)"d9f5eb4bba4e2f2f046e54611bc8196b");
            Assert.assertEquals((int)server.getRequestCount(), (int)2);
            this.assertAuthentication(server);
            RecordedRequest replace = server.takeRequest();
            this.assertRequest(replace, "PUT", "/v1/MossoCloudFS_5bcf396e-39dd-45ff-93a1-712b9aba90a9/myContainer/myObject");
            Assert.assertEquals((String)new String(replace.getBody()), (String)"swifty");
            for (Map.Entry<String, String> entry : metadata.entrySet()) {
                Assert.assertEquals((String)replace.getHeader("X-Object-Meta-" + entry.getKey().toLowerCase()), (String)entry.getValue());
            }
        }
        finally {
            server.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testCreateWithSpacesAndSpecialCharacters() throws Exception {
        MockWebServer server = ObjectApiMockTest.mockOpenStackServer();
        server.enqueue(this.addCommonHeaders(new MockResponse().setBody(this.stringFromResource("/access.json"))));
        server.enqueue(this.addCommonHeaders(new MockResponse().setResponseCode(201).addHeader("ETag", (Object)"d9f5eb4bba4e2f2f046e54611bc8196b")));
        String containerName = "container # ! special";
        String objectName = "object # ! special";
        try {
            SwiftApi api = (SwiftApi)this.api(server.getUrl("/").toString(), "openstack-swift");
            Assert.assertEquals((String)api.getObjectApi("DFW", "container # ! special").put("object # ! special", PAYLOAD, PutOptions.Builder.metadata(metadata)), (String)"d9f5eb4bba4e2f2f046e54611bc8196b");
            Assert.assertEquals((int)server.getRequestCount(), (int)2);
            this.assertAuthentication(server);
            RecordedRequest replace = server.takeRequest();
            this.assertRequest(replace, "PUT", "/v1/MossoCloudFS_5bcf396e-39dd-45ff-93a1-712b9aba90a9/container%20%23%20%21%20special/object%20%23%20%21%20special");
            Assert.assertEquals((String)new String(replace.getBody()), (String)"swifty");
        }
        finally {
            server.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testCreateWith408Retry() throws Exception {
        MockWebServer server = ObjectApiMockTest.mockOpenStackServer();
        server.enqueue(this.addCommonHeaders(new MockResponse().setBody(this.stringFromResource("/access.json"))));
        server.enqueue(this.addCommonHeaders(new MockResponse().setResponseCode(408)));
        server.enqueue(this.addCommonHeaders(new MockResponse().setResponseCode(408)));
        server.enqueue(this.addCommonHeaders(new MockResponse().setResponseCode(408)));
        server.enqueue(this.addCommonHeaders(new MockResponse().setResponseCode(201).addHeader("ETag", (Object)"d9f5eb4bba4e2f2f046e54611bc8196b")));
        try {
            Properties overrides = new Properties();
            overrides.setProperty("jclouds.max-retries", "5");
            SwiftApi api = (SwiftApi)this.api(server.getUrl("/").toString(), "openstack-swift", overrides);
            Assert.assertEquals((String)api.getObjectApi("DFW", "myContainer").put("myObject", PAYLOAD, PutOptions.Builder.metadata(metadata)), (String)"d9f5eb4bba4e2f2f046e54611bc8196b");
            Assert.assertEquals((int)server.getRequestCount(), (int)5);
            this.assertAuthentication(server);
            RecordedRequest replace = server.takeRequest();
            this.assertRequest(replace, "PUT", "/v1/MossoCloudFS_5bcf396e-39dd-45ff-93a1-712b9aba90a9/myContainer/myObject");
            Assert.assertEquals((String)new String(replace.getBody()), (String)"swifty");
            for (Map.Entry<String, String> entry : metadata.entrySet()) {
                Assert.assertEquals((String)replace.getHeader("X-Object-Meta-" + entry.getKey().toLowerCase()), (String)entry.getValue());
            }
        }
        finally {
            server.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testGetWithoutKnowingServerMessesWithMetadataKeyCaseFormat() throws Exception {
        MockWebServer server = ObjectApiMockTest.mockOpenStackServer();
        server.enqueue(this.addCommonHeaders(new MockResponse().setBody(this.stringFromResource("/access.json"))));
        server.enqueue(this.addCommonHeaders(ObjectApiMockTest.objectResponse().addHeader("X-Object-Meta-Apiname", (Object)"swift").addHeader("X-Object-Meta-Apiversion", (Object)"v1.1")));
        try {
            SwiftApi api = (SwiftApi)this.api(server.getUrl("/").toString(), "openstack-swift");
            SwiftObject object = api.getObjectApi("DFW", "myContainer").getWithoutBody("myObject");
            Assert.assertEquals((String)object.getName(), (String)"myObject");
            Assert.assertEquals((String)object.getETag(), (String)"8a964ee2a5e88be344f36c22562a6486");
            Assert.assertEquals((byte[])BaseEncoding.base16().lowerCase().decode((CharSequence)object.getETag()), (byte[])object.getPayload().getContentMetadata().getContentMD5AsHashCode().asBytes());
            Assert.assertEquals((Object)object.getLastModified(), (Object)this.dates.rfc822DateParse("Fri, 12 Jun 2010 13:40:18 GMT"));
            for (Map.Entry entry : object.getMetadata().entrySet()) {
                Assert.assertEquals((String)((String)object.getMetadata().get(((String)entry.getKey()).toLowerCase())), (String)((String)entry.getValue()));
            }
            Assert.assertEquals((String)object.getPayload().getContentMetadata().getContentType(), (String)"text/plain; charset=UTF-8");
            Assert.assertEquals((String)Strings2.toStringAndClose((InputStream)object.getPayload().openStream()), (String)"");
            Assert.assertEquals((int)server.getRequestCount(), (int)2);
            this.assertAuthentication(server);
            this.assertRequest(server.takeRequest(), "HEAD", "/v1/MossoCloudFS_5bcf396e-39dd-45ff-93a1-712b9aba90a9/myContainer/myObject");
        }
        finally {
            server.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testGet() throws Exception {
        MockWebServer server = ObjectApiMockTest.mockOpenStackServer();
        server.enqueue(this.addCommonHeaders(new MockResponse().setBody(this.stringFromResource("/access.json"))));
        server.enqueue(this.addCommonHeaders(ObjectApiMockTest.objectResponse().addHeader("X-Object-Meta-Apiname", (Object)"swift").addHeader("X-Object-Meta-Apiversion", (Object)"v1.1")));
        try {
            SwiftApi api = (SwiftApi)this.api(server.getUrl("/").toString(), "openstack-swift");
            SwiftObject object = api.getObjectApi("DFW", "myContainer").get("myObject", GetOptions.Builder.tail((long)1L));
            Assert.assertEquals((String)object.getName(), (String)"myObject");
            Assert.assertEquals((String)object.getETag(), (String)"8a964ee2a5e88be344f36c22562a6486");
            Assert.assertEquals((Object)object.getLastModified(), (Object)this.dates.rfc822DateParse("Fri, 12 Jun 2010 13:40:18 GMT"));
            for (Map.Entry entry : object.getMetadata().entrySet()) {
                Assert.assertEquals((String)((String)object.getMetadata().get(((String)entry.getKey()).toLowerCase())), (String)((String)entry.getValue()));
            }
            Payload payload = object.getPayload();
            Assert.assertEquals((Object)payload.getContentMetadata().getContentLength(), (Object)4L);
            Assert.assertEquals((String)payload.getContentMetadata().getContentType(), (String)"text/plain; charset=UTF-8");
            Assert.assertEquals((Object)payload.getContentMetadata().getExpires(), (Object)this.dates.rfc822DateParse("Wed, 23 Jul 2014 14:00:00 GMT"));
            Assert.assertEquals((String)Strings2.toStringAndClose((InputStream)payload.openStream()), (String)"ABCD");
            Assert.assertEquals((int)server.getRequestCount(), (int)2);
            Assert.assertEquals((String)server.takeRequest().getRequestLine(), (String)"POST /tokens HTTP/1.1");
            RecordedRequest get = server.takeRequest();
            Assert.assertEquals((String)get.getRequestLine(), (String)"GET /v1/MossoCloudFS_5bcf396e-39dd-45ff-93a1-712b9aba90a9/myContainer/myObject HTTP/1.1");
        }
        finally {
            server.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(expectedExceptions={HttpResponseException.class}, timeOut=20000L)
    public void testCreateWithTimeout() throws Exception {
        MockWebServer server = ObjectApiMockTest.mockOpenStackServer();
        server.enqueue(this.addCommonHeaders(new MockResponse().setBody(this.stringFromResource("/access.json"))));
        try {
            Properties overrides = new Properties();
            overrides.setProperty("jclouds.so-timeout", "5000");
            overrides.setProperty("jclouds.max-retries", "0");
            overrides.setProperty("jclouds.retries-delay-start", "0");
            SwiftApi api = (SwiftApi)this.api(server.getUrl("/").toString(), "openstack-swift", overrides);
            api.getObjectApi("DFW", "myContainer").put("myObject", (Payload)new ByteSourcePayload(ByteSource.wrap((byte[])"swifty".getBytes())), PutOptions.Builder.metadata(metadata));
            Assert.fail((String)"testReplaceTimeout test should have failed with an HttpResponseException.");
        }
        finally {
            server.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testUpdateMetadata() throws Exception {
        MockWebServer server = ObjectApiMockTest.mockOpenStackServer();
        server.enqueue(this.addCommonHeaders(new MockResponse().setBody(this.stringFromResource("/access.json"))));
        server.enqueue(this.addCommonHeaders(ObjectApiMockTest.objectResponse().addHeader("X-Object-Meta-ApiName", (Object)"swift").addHeader("X-Object-Meta-ApiVersion", (Object)"v1.1")));
        try {
            SwiftApi api = (SwiftApi)this.api(server.getUrl("/").toString(), "openstack-swift");
            Assert.assertTrue((boolean)api.getObjectApi("DFW", "myContainer").updateMetadata("myObject", metadata));
            Assert.assertEquals((int)server.getRequestCount(), (int)2);
            Assert.assertEquals((String)server.takeRequest().getRequestLine(), (String)"POST /tokens HTTP/1.1");
            RecordedRequest replaceRequest = server.takeRequest();
            Assert.assertEquals((String)replaceRequest.getRequestLine(), (String)"POST /v1/MossoCloudFS_5bcf396e-39dd-45ff-93a1-712b9aba90a9/myContainer/myObject HTTP/1.1");
            for (Map.Entry<String, String> entry : metadata.entrySet()) {
                Assert.assertEquals((String)replaceRequest.getHeader("X-Object-Meta-" + entry.getKey().toLowerCase()), (String)entry.getValue());
            }
        }
        finally {
            server.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testUpdateMetadataContentType() throws Exception {
        MockWebServer server = ObjectApiMockTest.mockOpenStackServer();
        server.enqueue(this.addCommonHeaders(new MockResponse().setBody(this.stringFromResource("/access.json"))));
        server.enqueue(this.addCommonHeaders(ObjectApiMockTest.objectResponse().addHeader("X-Object-Meta-ApiName", (Object)"swift").addHeader("X-Object-Meta-ApiVersion", (Object)"v1.1")));
        try {
            SwiftApi api = (SwiftApi)this.api(server.getUrl("/").toString(), "openstack-swift");
            Assert.assertTrue((boolean)api.getObjectApi("DFW", "myContainer").updateMetadata("myObject", metadata));
            Assert.assertEquals((int)server.getRequestCount(), (int)2);
            Assert.assertEquals((String)server.takeRequest().getRequestLine(), (String)"POST /tokens HTTP/1.1");
            RecordedRequest replaceRequest = server.takeRequest();
            Assert.assertEquals((String)((String)replaceRequest.getHeaders("Content-Type").get(0)), (String)"", (String)("updateMetadata should send an empty content-type header, but sent " + ((String)replaceRequest.getHeaders("Content-Type").get(0)).toString()));
            Assert.assertEquals((String)replaceRequest.getRequestLine(), (String)"POST /v1/MossoCloudFS_5bcf396e-39dd-45ff-93a1-712b9aba90a9/myContainer/myObject HTTP/1.1");
            for (Map.Entry<String, String> entry : metadata.entrySet()) {
                Assert.assertEquals((String)replaceRequest.getHeader("X-Object-Meta-" + entry.getKey().toLowerCase()), (String)entry.getValue());
            }
        }
        finally {
            server.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testDeleteMetadata() throws Exception {
        MockWebServer server = ObjectApiMockTest.mockOpenStackServer();
        server.enqueue(this.addCommonHeaders(new MockResponse().setBody(this.stringFromResource("/access.json"))));
        server.enqueue(this.addCommonHeaders(ObjectApiMockTest.objectResponse()));
        try {
            SwiftApi api = (SwiftApi)this.api(server.getUrl("/").toString(), "openstack-swift");
            Assert.assertTrue((boolean)api.getObjectApi("DFW", "myContainer").deleteMetadata("myObject", metadata));
            Assert.assertEquals((int)server.getRequestCount(), (int)2);
            Assert.assertEquals((String)server.takeRequest().getRequestLine(), (String)"POST /tokens HTTP/1.1");
            RecordedRequest deleteRequest = server.takeRequest();
            Assert.assertEquals((String)deleteRequest.getRequestLine(), (String)"POST /v1/MossoCloudFS_5bcf396e-39dd-45ff-93a1-712b9aba90a9/myContainer/myObject HTTP/1.1");
            for (String key : metadata.keySet()) {
                Assert.assertEquals((String)deleteRequest.getHeader("X-Remove-Object-Meta-" + key.toLowerCase()), (String)"ignored");
            }
        }
        finally {
            server.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testDelete() throws Exception {
        MockWebServer server = ObjectApiMockTest.mockOpenStackServer();
        server.enqueue(this.addCommonHeaders(new MockResponse().setBody(this.stringFromResource("/access.json"))));
        server.enqueue(this.addCommonHeaders(new MockResponse().setResponseCode(204)));
        try {
            SwiftApi api = (SwiftApi)this.api(server.getUrl("/").toString(), "openstack-swift");
            api.getObjectApi("DFW", "myContainer").delete("myObject");
            Assert.assertEquals((int)server.getRequestCount(), (int)2);
            Assert.assertEquals((String)server.takeRequest().getRequestLine(), (String)"POST /tokens HTTP/1.1");
            RecordedRequest deleteRequest = server.takeRequest();
            Assert.assertEquals((String)deleteRequest.getRequestLine(), (String)"DELETE /v1/MossoCloudFS_5bcf396e-39dd-45ff-93a1-712b9aba90a9/myContainer/myObject HTTP/1.1");
        }
        finally {
            server.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testAlreadyDeleted() throws Exception {
        MockWebServer server = ObjectApiMockTest.mockOpenStackServer();
        server.enqueue(this.addCommonHeaders(new MockResponse().setBody(this.stringFromResource("/access.json"))));
        server.enqueue(this.addCommonHeaders(new MockResponse().setResponseCode(404)));
        try {
            SwiftApi api = (SwiftApi)this.api(server.getUrl("/").toString(), "openstack-swift");
            api.getObjectApi("DFW", "myContainer").delete("myObject");
            Assert.assertEquals((int)server.getRequestCount(), (int)2);
            Assert.assertEquals((String)server.takeRequest().getRequestLine(), (String)"POST /tokens HTTP/1.1");
            RecordedRequest deleteRequest = server.takeRequest();
            Assert.assertEquals((String)deleteRequest.getRequestLine(), (String)"DELETE /v1/MossoCloudFS_5bcf396e-39dd-45ff-93a1-712b9aba90a9/myContainer/myObject HTTP/1.1");
        }
        finally {
            server.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testCopyObject() throws Exception {
        MockWebServer server = ObjectApiMockTest.mockOpenStackServer();
        server.enqueue(this.addCommonHeaders(new MockResponse().setBody(this.stringFromResource("/access.json"))));
        server.enqueue(this.addCommonHeaders(new MockResponse().setResponseCode(201).addHeader("X-Copy-From", (Object)"/bar/foo.txt")));
        try {
            SwiftApi api = (SwiftApi)this.api(server.getUrl("/").toString(), "openstack-swift");
            Assert.assertTrue((boolean)api.getObjectApi("DFW", "foo").copy("bar.txt", "bar", "foo.txt"));
            Assert.assertEquals((int)server.getRequestCount(), (int)2);
            Assert.assertEquals((String)server.takeRequest().getRequestLine(), (String)"POST /tokens HTTP/1.1");
            RecordedRequest copyRequest = server.takeRequest();
            Assert.assertEquals((String)copyRequest.getRequestLine(), (String)"PUT /v1/MossoCloudFS_5bcf396e-39dd-45ff-93a1-712b9aba90a9/foo/bar.txt HTTP/1.1");
        }
        finally {
            server.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(expectedExceptions={CopyObjectException.class})
    public void testCopyObjectFail() throws InterruptedException, IOException {
        MockWebServer server = ObjectApiMockTest.mockOpenStackServer();
        server.enqueue(this.addCommonHeaders(new MockResponse().setBody(this.stringFromResource("/access.json"))));
        server.enqueue(this.addCommonHeaders(new MockResponse().setResponseCode(404).addHeader("X-Copy-From", (Object)"/bogus/foo.txt")));
        try {
            SwiftApi api = (SwiftApi)this.api(server.getUrl("/").toString(), "openstack-swift");
            api.getObjectApi("DFW", "foo").copy("bar.txt", "bogus", "foo.txt");
        }
        finally {
            server.shutdown();
        }
    }

    static MockResponse objectResponse() {
        return new MockResponse().addHeader("Last-Modified", (Object)"Fri, 12 Jun 2010 13:40:18 GMT").addHeader("ETag", (Object)"8a964ee2a5e88be344f36c22562a6486").setBody("ABCD".getBytes(Charsets.US_ASCII)).addHeader("Content-Length", (Object)"4").addHeader("Content-Type", (Object)"text/plain; charset=UTF-8").addHeader("Expires", (Object)"Wed, 23 Jul 2014 14:00:00 GMT");
    }

    static Payload payload(long bytes, String contentType, Date expires) {
        ByteSourcePayload payload = Payloads.newByteSourcePayload((ByteSource)ByteSource.empty());
        payload.getContentMetadata().setContentLength(Long.valueOf(bytes));
        payload.getContentMetadata().setContentType(contentType);
        payload.getContentMetadata().setExpires(expires);
        return payload;
    }
}

