/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.swift.v1.features;

import com.google.common.collect.ImmutableMap;
import com.google.common.io.ByteSource;
import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.jclouds.http.options.GetOptions;
import org.jclouds.io.Payload;
import org.jclouds.io.Payloads;
import org.jclouds.io.payloads.ByteSourcePayload;
import org.jclouds.openstack.swift.v1.CopyObjectException;
import org.jclouds.openstack.swift.v1.SwiftApi;
import org.jclouds.openstack.swift.v1.domain.ObjectList;
import org.jclouds.openstack.swift.v1.domain.SwiftObject;
import org.jclouds.openstack.swift.v1.features.ContainerApi;
import org.jclouds.openstack.swift.v1.features.ObjectApi;
import org.jclouds.openstack.swift.v1.internal.BaseSwiftApiLiveTest;
import org.jclouds.openstack.swift.v1.options.ListContainerOptions;
import org.jclouds.util.Strings2;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

@Test(groups={"live"}, testName="ObjectApiLiveTest", singleThreaded=true)
public class ObjectApiLiveTest
extends BaseSwiftApiLiveTest<SwiftApi> {
    private String name = ((Object)((Object)this)).getClass().getSimpleName();
    private String containerName = ((Object)((Object)this)).getClass().getSimpleName() + "Container";
    static final Payload PAYLOAD = Payloads.newByteSourcePayload((ByteSource)ByteSource.wrap((byte[])"swifty".getBytes()));

    public void testCreateWithSpacesAndSpecialCharacters() throws Exception {
        String containerName = "container # ! special";
        String objectName = "object # ! special";
        for (String regionId : this.regions) {
            Assert.assertNotNull((Object)((SwiftApi)this.api).getContainerApi(regionId).create("container # ! special"));
            Assert.assertNotNull((Object)((SwiftApi)this.api).getObjectApi(regionId, "container # ! special").put("object # ! special", PAYLOAD));
            SwiftObject object = ((SwiftApi)this.api).getObjectApi(regionId, "container # ! special").get("object # ! special");
            Assert.assertEquals((String)object.getName(), (String)"object # ! special");
            ObjectApiLiveTest.checkObject(object);
            Assert.assertEquals((String)Strings2.toStringAndClose((InputStream)object.getPayload().openStream()), (String)"swifty");
            ((SwiftApi)this.api).getObjectApi(regionId, "container # ! special").delete("object # ! special");
            ((SwiftApi)this.api).getContainerApi(regionId).deleteIfEmpty("container # ! special");
        }
    }

    public void testPutWithExpiration() throws Exception {
        String objectName = "test-expiration";
        long expireMillis = new Date().getTime() + 86400000L;
        Date expireAt = new Date(expireMillis);
        ByteSourcePayload payload = Payloads.newByteSourcePayload((ByteSource)ByteSource.wrap((byte[])"swifty".getBytes()));
        payload.getContentMetadata().setExpires(expireAt);
        for (String regionId : this.regions) {
            String etag = ((SwiftApi)this.api).getObjectApi(regionId, this.containerName).put(objectName, (Payload)payload);
            Assert.assertNotNull((Object)etag);
            SwiftObject object = ((SwiftApi)this.api).getObjectApi(regionId, this.containerName).get(objectName);
            Assert.assertEquals((String)object.getName(), (String)objectName);
            ObjectApiLiveTest.checkObject(object);
            Assert.assertEquals((String)Strings2.toStringAndClose((InputStream)object.getPayload().openStream()), (String)"swifty");
            ((SwiftApi)this.api).getObjectApi(regionId, this.containerName).delete(objectName);
        }
    }

    public void testCopyObject() throws Exception {
        for (String regionId : this.regions) {
            String sourceContainer = "src" + this.containerName;
            String sourceObjectName = "original.txt";
            String badSource = "badSource";
            String destinationContainer = "dest" + this.containerName;
            String destinationObject = "copy.txt";
            String destinationPath = "/" + destinationContainer + "/" + destinationObject;
            ContainerApi containerApi = ((SwiftApi)this.api).getContainerApi(regionId);
            containerApi.create(sourceContainer);
            containerApi.create(destinationContainer);
            ObjectApi srcApi = ((SwiftApi)this.api).getObjectApi(regionId, sourceContainer);
            ObjectApi destApi = ((SwiftApi)this.api).getObjectApi(regionId, destinationContainer);
            Assert.assertNotNull((Object)srcApi.put(sourceObjectName, PAYLOAD));
            SwiftObject sourceObject = srcApi.get(sourceObjectName);
            ObjectApiLiveTest.checkObject(sourceObject);
            Assert.assertNotNull((Object)destApi.put(destinationObject, PAYLOAD));
            SwiftObject object = destApi.get(destinationObject);
            ObjectApiLiveTest.checkObject(object);
            Assert.assertTrue((boolean)destApi.copy(destinationObject, sourceContainer, sourceObjectName));
            Assert.assertNotNull((Object)destApi.get(destinationObject));
            SwiftObject destSwiftObject = destApi.get(destinationObject);
            Assert.assertEquals((String)Strings2.toStringAndClose((InputStream)destSwiftObject.getPayload().openStream()), (String)"swifty");
            try {
                destApi.copy(destinationObject, badSource, sourceObjectName);
                Assert.fail((String)"Expected CopyObjectException");
            }
            catch (CopyObjectException e) {
                Assert.assertEquals((String)e.getSourcePath(), (String)("/" + badSource + "/" + sourceObjectName));
                Assert.assertEquals((String)e.getDestinationPath(), (String)destinationPath);
            }
            this.deleteAllObjectsInContainer(regionId, sourceContainer);
            containerApi.deleteIfEmpty(sourceContainer);
            this.deleteAllObjectsInContainer(regionId, destinationContainer);
            containerApi.deleteIfEmpty(destinationContainer);
        }
    }

    public void testList() throws Exception {
        for (String regionId : this.regions) {
            ObjectApi objectApi = ((SwiftApi)this.api).getObjectApi(regionId, this.containerName);
            ObjectList response = objectApi.list();
            Assert.assertEquals((Object)response.getContainer(), (Object)((SwiftApi)this.api).getContainerApi(regionId).get(this.containerName));
            for (SwiftObject object : response) {
                ObjectApiLiveTest.checkObject(object);
            }
        }
    }

    public void testListWithOptions() throws Exception {
        for (String regionId : this.regions) {
            ObjectApi objectApi = ((SwiftApi)this.api).getObjectApi(regionId, this.containerName);
            ObjectList response = objectApi.list(ListContainerOptions.NONE);
            Assert.assertEquals((Object)response.getContainer(), (Object)((SwiftApi)this.api).getContainerApi(regionId).get(this.containerName));
            for (SwiftObject object : response) {
                ObjectApiLiveTest.checkObject(object);
            }
        }
    }

    public void testMetadata() throws Exception {
        for (String regionId : this.regions) {
            SwiftObject object = ((SwiftApi)this.api).getObjectApi(regionId, this.containerName).get(this.name);
            Assert.assertEquals((String)object.getName(), (String)this.name);
            ObjectApiLiveTest.checkObject(object);
            Assert.assertEquals((String)Strings2.toStringAndClose((InputStream)object.getPayload().openStream()), (String)"swifty");
        }
    }

    public void testUpdateMetadata() throws Exception {
        for (String regionId : this.regions) {
            ObjectApi objectApi = ((SwiftApi)this.api).getObjectApi(regionId, this.containerName);
            ImmutableMap meta = ImmutableMap.of((Object)"MyAdd1", (Object)"foo", (Object)"MyAdd2", (Object)"bar");
            Assert.assertTrue((boolean)objectApi.updateMetadata(this.name, (Map)meta));
            SwiftObject object = objectApi.get(this.name);
            for (Map.Entry entry : meta.entrySet()) {
                Assert.assertEquals((String)((String)object.getMetadata().get(((String)entry.getKey()).toLowerCase())), (String)((String)entry.getValue()), (String)(object + " didn't have metadata: " + entry));
            }
        }
    }

    public void testGet() throws Exception {
        for (String regionId : this.regions) {
            SwiftObject object = ((SwiftApi)this.api).getObjectApi(regionId, this.containerName).get(this.name, GetOptions.NONE);
            Assert.assertEquals((String)object.getName(), (String)this.name);
            ObjectApiLiveTest.checkObject(object);
            Assert.assertEquals((String)Strings2.toStringAndClose((InputStream)object.getPayload().openStream()), (String)"swifty");
        }
    }

    public void testPrivateByDefault() throws Exception {
        for (String regionId : this.regions) {
            SwiftObject object = ((SwiftApi)this.api).getObjectApi(regionId, this.containerName).get(this.name);
            try {
                object.getUri().toURL().openStream();
                Assert.fail((String)("shouldn't be able to access " + object));
            }
            catch (IOException expected) {}
        }
    }

    public void testGetOptions() throws Exception {
        for (String regionId : this.regions) {
            SwiftObject object = ((SwiftApi)this.api).getObjectApi(regionId, this.containerName).get(this.name, GetOptions.Builder.tail((long)1L));
            Assert.assertEquals((String)object.getName(), (String)this.name);
            ObjectApiLiveTest.checkObject(object);
            Assert.assertEquals((String)Strings2.toStringAndClose((InputStream)object.getPayload().openStream()), (String)"y");
        }
    }

    public void testListOptions() throws Exception {
        String lexicographicallyBeforeName = this.name.substring(0, this.name.length() - 1);
        for (String regionId : this.regions) {
            SwiftObject object = (SwiftObject)((SwiftApi)this.api).getObjectApi(regionId, this.containerName).list(ListContainerOptions.Builder.marker((String)lexicographicallyBeforeName)).get(0);
            Assert.assertEquals((String)object.getName(), (String)this.name);
            ObjectApiLiveTest.checkObject(object);
        }
    }

    public void testDeleteMetadata() throws Exception {
        for (String regionId : this.regions) {
            ObjectApi objectApi = ((SwiftApi)this.api).getObjectApi(regionId, this.containerName);
            ImmutableMap meta = ImmutableMap.of((Object)"MyDelete1", (Object)"foo", (Object)"MyDelete2", (Object)"bar");
            Assert.assertTrue((boolean)objectApi.updateMetadata(this.name, (Map)meta));
            Assert.assertFalse((boolean)objectApi.get(this.name).getMetadata().isEmpty());
            Assert.assertTrue((boolean)objectApi.deleteMetadata(this.name, (Map)meta));
            Assert.assertTrue((boolean)objectApi.get(this.name).getMetadata().isEmpty());
        }
    }

    @Override
    @BeforeClass(groups={"live"})
    public void setup() {
        super.setup();
        for (String regionId : this.regions) {
            ((SwiftApi)this.api).getContainerApi(regionId).create(this.containerName);
            ((SwiftApi)this.api).getObjectApi(regionId, this.containerName).put(this.name, PAYLOAD);
        }
    }

    @AfterClass(groups={"live"})
    public void tearDown() {
        for (String regionId : this.regions) {
            this.deleteAllObjectsInContainer(regionId, this.containerName);
            ((SwiftApi)this.api).getObjectApi(regionId, this.containerName).delete(this.name);
            ((SwiftApi)this.api).getContainerApi(regionId).deleteIfEmpty(this.containerName);
        }
        super.tearDown();
    }

    static void checkObject(SwiftObject object) {
        Assert.assertNotNull((Object)object.getName());
        Assert.assertNotNull((Object)object.getUri());
        Assert.assertNotNull((Object)object.getETag());
        Assert.assertTrue((object.getLastModified().getTime() <= System.currentTimeMillis() + TimeUnit.MINUTES.toMillis(5L) ? 1 : 0) != 0);
        Assert.assertNotNull((Object)object.getPayload().getContentMetadata().getContentLength());
        Assert.assertNotNull((Object)object.getPayload().getContentMetadata().getContentType());
    }
}

