/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.swift.v1.features;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.jclouds.openstack.swift.v1.SwiftApi;
import org.jclouds.openstack.swift.v1.domain.Account;
import org.jclouds.openstack.swift.v1.features.AccountApi;
import org.jclouds.openstack.swift.v1.internal.BaseSwiftApiLiveTest;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"live"}, testName="AccountApiLiveTest")
public class AccountApiLiveTest
extends BaseSwiftApiLiveTest<SwiftApi> {
    public void testGet() throws Exception {
        for (String regionId : this.regions) {
            AccountApi accountApi = ((SwiftApi)this.api).getAccountApi(regionId);
            Account account = accountApi.get();
            Assert.assertNotNull((Object)account);
            Assert.assertTrue((account.getContainerCount() >= 0L ? 1 : 0) != 0);
            Assert.assertTrue((account.getObjectCount() >= 0L ? 1 : 0) != 0);
            Assert.assertTrue((account.getBytesUsed() >= 0L ? 1 : 0) != 0);
        }
    }

    public void testUpdateMetadata() throws Exception {
        for (String regionId : this.regions) {
            AccountApi accountApi = ((SwiftApi)this.api).getAccountApi(regionId);
            ImmutableMap meta = ImmutableMap.of((Object)"MyAdd1", (Object)"foo", (Object)"MyAdd2", (Object)"bar");
            Assert.assertTrue((boolean)accountApi.updateMetadata((Map)meta));
            AccountApiLiveTest.accountHasMetadata(accountApi, (Map<String, String>)meta);
        }
    }

    public void testDeleteMetadata() throws Exception {
        for (String regionId : this.regions) {
            AccountApi accountApi = ((SwiftApi)this.api).getAccountApi(regionId);
            ImmutableMap meta = ImmutableMap.of((Object)"MyDelete1", (Object)"foo", (Object)"MyDelete2", (Object)"bar");
            Assert.assertTrue((boolean)accountApi.updateMetadata((Map)meta));
            AccountApiLiveTest.accountHasMetadata(accountApi, (Map<String, String>)meta);
            Assert.assertTrue((boolean)accountApi.deleteMetadata((Map)meta));
            Account account = accountApi.get();
            for (Map.Entry entry : meta.entrySet()) {
                Assert.assertFalse((boolean)account.getMetadata().containsKey(((String)entry.getKey()).toLowerCase()));
            }
        }
    }

    static void accountHasMetadata(AccountApi accountApi, Map<String, String> meta) {
        Account account = accountApi.get();
        for (Map.Entry<String, String> entry : meta.entrySet()) {
            Assert.assertEquals((String)((String)account.getMetadata().get(entry.getKey().toLowerCase())), (String)entry.getValue(), (String)(account + " didn't have metadata: " + entry));
        }
    }
}

