/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.swift.v1.config;

import com.google.common.collect.ImmutableMap;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.util.Map;
import org.jclouds.openstack.swift.v1.config.SwiftTypeAdapters;
import org.jclouds.openstack.swift.v1.domain.BulkDeleteResponse;
import org.jclouds.openstack.swift.v1.domain.ExtractArchiveResponse;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test
public class SwiftTypeAdaptersTest {
    Gson gson = new GsonBuilder().registerTypeAdapter(ExtractArchiveResponse.class, (Object)new SwiftTypeAdapters.ExtractArchiveResponseAdapter()).registerTypeAdapter(BulkDeleteResponse.class, (Object)new SwiftTypeAdapters.BulkDeleteResponseAdapter()).create();

    public void extractArchiveWithoutErrors() {
        Assert.assertEquals((Object)this.gson.fromJson("{\n  \"Response Status\": \"201 Created\",\n  \"Response Body\": \"\",\n  \"Errors\": [],\n  \"Number Files Created\": 10\n}", ExtractArchiveResponse.class), (Object)ExtractArchiveResponse.create((int)10, (Map)ImmutableMap.of()));
    }

    public void extractArchiveWithErrorsAndDecodesPaths() {
        Assert.assertEquals((Object)this.gson.fromJson("{\n  \"Response Status\": \"201 Created\",\n  \"Response Body\": \"\",\n  \"Errors\": [\n    [\"/v1/12345678912345/mycontainer/home/xx%3Cyy\", \"400 Bad Request\"],\n    [\"/v1/12345678912345/mycontainer/../image.gif\", \"400 Bad Request\"]\n  ],\n  \"Number Files Created\": 8\n}", ExtractArchiveResponse.class), (Object)ExtractArchiveResponse.create((int)8, (Map)ImmutableMap.builder().put((Object)"/v1/12345678912345/mycontainer/home/xx<yy", (Object)"400 Bad Request").put((Object)"/v1/12345678912345/mycontainer/../image.gif", (Object)"400 Bad Request").build()));
    }

    public void bulkDeleteWithoutErrors() {
        Assert.assertEquals((Object)this.gson.fromJson("{\n  \"Response Status\": \"200 OK\",\n  \"Response Body\": \"\",\n  \"Errors\": [],\n  \"Number Not Found\": 1,\n  \"Number Deleted\": 9\n}", BulkDeleteResponse.class), (Object)BulkDeleteResponse.create((int)9, (int)1, (Map)ImmutableMap.of()));
    }

    public void bulkDeleteWithErrorsAndDecodesPaths() {
        Assert.assertEquals((Object)this.gson.fromJson("{\n  \"Response Status\": \"400 Bad Request\",\n  \"Response Body\": \"\",\n  \"Errors\": [\n    [\"/v1/12345678912345/Not%20Empty\", \"409 Conflict\"]  ],\n  \"Number Deleted\": 0\n}", BulkDeleteResponse.class), (Object)BulkDeleteResponse.create((int)0, (int)0, (Map)ImmutableMap.of((Object)"/v1/12345678912345/Not Empty", (Object)"409 Conflict")));
    }
}

