/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.swift.v1.blobstore.integration;

import java.util.Properties;
import org.jclouds.blobstore.domain.Blob;
import org.jclouds.blobstore.integration.internal.BaseBlobIntegrationTest;
import org.testng.SkipException;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

@Test(groups={"live"}, testName="SwiftBlobIntegrationLiveTest")
public class SwiftBlobIntegrationLiveTest
extends BaseBlobIntegrationTest {
    public SwiftBlobIntegrationLiveTest() {
        this.provider = "openstack-swift";
    }

    protected Properties setupProperties() {
        Properties props = super.setupProperties();
        this.setIfTestSystemPropertyPresent(props, "jclouds.keystone.credential-type");
        return props;
    }

    @DataProvider(name="delete")
    public Object[][] createData() {
        return new Object[][]{{"normal"}, {"sp ace"}, {"qu?stion"}, {"unic\u20aade"}, {"path/foo"}, {"colon:"}, {"asteri*k"}, {"p|pe"}};
    }

    public void testGetTwoRanges() {
        throw new SkipException("unsupported in swift");
    }

    public void testCreateBlobWithExpiry() throws InterruptedException {
        throw new SkipException("unsupported in swift");
    }

    @Test(groups={"integration", "live"})
    public void testGetIfUnmodifiedSince() throws InterruptedException {
        throw new SkipException("unsupported in swift");
    }

    protected int getIncorrectContentMD5StatusCode() {
        return 422;
    }

    protected void checkContentLanguage(Blob blob, String contentLanguage) {
        assert (blob.getPayload().getContentMetadata().getContentLanguage() == null);
        assert (blob.getMetadata().getContentMetadata().getContentLanguage() == null);
    }
}

