/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.swift.v1.blobstore;

import com.google.common.collect.Iterables;
import com.google.common.hash.Hashing;
import com.google.common.io.ByteSource;
import com.google.common.net.MediaType;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import org.jclouds.blobstore.BlobRequestSigner;
import org.jclouds.blobstore.BlobStore;
import org.jclouds.blobstore.domain.Blob;
import org.jclouds.blobstore.domain.PageSet;
import org.jclouds.blobstore.domain.StorageMetadata;
import org.jclouds.blobstore.integration.internal.BaseBlobStoreIntegrationTest;
import org.jclouds.domain.Location;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.HttpResponse;
import org.jclouds.io.ByteStreams2;
import org.jclouds.io.MutableContentMetadata;
import org.jclouds.io.Payload;
import org.jclouds.io.Payloads;
import org.jclouds.openstack.swift.v1.blobstore.RegionScopedBlobStoreContext;
import org.jclouds.rest.HttpClient;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"live"})
public class RegionScopedBlobStoreContextLiveTest
extends BaseBlobStoreIntegrationTest {
    public RegionScopedBlobStoreContextLiveTest() {
        this.provider = "openstack-swift";
    }

    protected Properties setupProperties() {
        Properties props = super.setupProperties();
        this.setIfTestSystemPropertyPresent(props, "jclouds.keystone.credential-type");
        return props;
    }

    @Test
    public void testRegionsAreNotEmpty() {
        Assert.assertFalse((boolean)((RegionScopedBlobStoreContext)RegionScopedBlobStoreContext.class.cast(this.view)).getConfiguredRegions().isEmpty());
    }

    @Test
    public void testLocationsMatch() {
        RegionScopedBlobStoreContext ctx = (RegionScopedBlobStoreContext)RegionScopedBlobStoreContext.class.cast(this.view);
        for (String regionId : ctx.getConfiguredRegions()) {
            Set locations = ctx.getBlobStore(regionId).listAssignableLocations();
            Assert.assertEquals((int)locations.size(), (int)1, (String)("expected one region " + regionId + " " + locations));
            Location location = (Location)locations.iterator().next();
            Assert.assertEquals((String)location.getId(), (String)regionId, (String)("region id " + regionId + " didn't match getId(): " + location));
        }
    }

    @Test
    public void testListBlobs() throws InterruptedException, ExecutionException {
        RegionScopedBlobStoreContext ctx = (RegionScopedBlobStoreContext)RegionScopedBlobStoreContext.class.cast(this.view);
        for (String regionId : ctx.getConfiguredRegions()) {
            ctx.getBlobStore(regionId).list();
        }
    }

    @Test
    public void testSign() throws InterruptedException, ExecutionException, IOException {
        RegionScopedBlobStoreContext ctx = (RegionScopedBlobStoreContext)RegionScopedBlobStoreContext.class.cast(this.view);
        for (String regionId : ctx.getConfiguredRegions()) {
            HttpResponse response;
            BlobStore region = ctx.getBlobStore(regionId);
            PageSet containers = region.list();
            if (containers.isEmpty()) continue;
            String containerName = ((StorageMetadata)Iterables.getLast((Iterable)containers)).getName();
            ByteSource input = ByteSource.wrap((byte[])"str".getBytes());
            HttpClient client = ctx.utils().http();
            String blobName = "test-" + UUID.randomUUID();
            Blob blob2 = region.blobBuilder(blobName).forSigning().contentLength(input.size()).contentMD5(input.hash(Hashing.md5()).asBytes()).contentType(MediaType.OCTET_STREAM.toString()).build();
            BlobRequestSigner signer = ctx.getSigner(regionId);
            try {
                HttpRequest putRequest = signer.signPutBlob(containerName, blob2, 600L);
                MutableContentMetadata metadata = blob2.getMetadata().getContentMetadata();
                HttpRequest.Builder putRequestBuilder = (HttpRequest.Builder)putRequest.toBuilder().addHeader("Content-Type", new String[]{metadata.getContentType()});
                putRequestBuilder.addHeader("Content-Length", new String[]{String.valueOf(input.size())});
                putRequestBuilder.payload(input);
                putRequest = putRequestBuilder.build();
                Payload payload = Payloads.newPayload((Object)input.read());
                putRequest.setPayload(payload);
                Assert.assertNotNull((Object)putRequest, (String)("regionId=" + regionId + ", container=" + containerName + ", blob=" + blobName));
                response = client.invoke(putRequest);
                if (response.getStatusCode() != 200 && response.getStatusCode() != 201) {
                    Assert.fail((String)("Signed PUT expected to return 200 or 201 but returned " + response.getStatusCode()));
                }
            }
            catch (Exception e) {
                Assert.fail((String)("Failed signed put test: " + e));
            }
            try {
                HttpRequest getRequest = signer.signGetBlob(containerName, blobName);
                Assert.assertNotNull((Object)getRequest, (String)("regionId=" + regionId + ", container=" + containerName + ", blob=" + blobName));
                response = client.invoke(getRequest);
                if (response.getStatusCode() != 200) {
                    Assert.fail((String)("Signed GET expected to return 200 but returned " + response.getStatusCode()));
                }
                Payload payload = response.getPayload();
                Assert.assertEquals((byte[])ByteStreams2.toByteArrayAndClose((InputStream)payload.openStream()), (byte[])input.read(), (String)"Data with signed GET not identical to what was put");
            }
            catch (Exception e) {
                Assert.fail((String)("Failed signed GET test: " + e));
            }
        }
    }
}

