/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.swift.v1;

import com.google.common.io.ByteSource;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.UUID;
import org.jclouds.io.Payload;
import org.jclouds.io.Payloads;
import org.jclouds.openstack.swift.v1.SwiftApi;
import org.jclouds.openstack.swift.v1.TemporaryUrlSigner;
import org.jclouds.openstack.swift.v1.domain.SwiftObject;
import org.jclouds.openstack.swift.v1.features.AccountApi;
import org.jclouds.openstack.swift.v1.internal.BaseSwiftApiLiveTest;
import org.jclouds.util.Strings2;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

@Test(groups={"live"}, testName="TemporaryUrlSignerLiveTest")
public class TemporaryUrlSignerLiveTest
extends BaseSwiftApiLiveTest<SwiftApi> {
    private String name = ((Object)((Object)this)).getClass().getSimpleName();
    private String containerName = ((Object)((Object)this)).getClass().getSimpleName() + "Container";

    public void signForPublicAccess() throws Exception {
        for (String regionId : ((SwiftApi)this.api).getConfiguredRegions()) {
            SwiftObject object = ((SwiftApi)this.api).getObjectApi(regionId, this.containerName).get(this.name);
            long expires = System.currentTimeMillis() / 1000L + 5L;
            String signature = TemporaryUrlSigner.checkApiEvery((AccountApi)((SwiftApi)this.api).getAccountApi(regionId), (long)5L).sign("GET", object.getUri().getPath(), expires);
            URI signed = URI.create(String.format("%s?temp_url_sig=%s&temp_url_expires=%s", object.getUri(), signature, expires));
            InputStream publicStream = signed.toURL().openStream();
            Assert.assertEquals((String)Strings2.toStringAndClose((InputStream)publicStream), (String)"swifty");
            Thread.sleep(5000L);
            try {
                signed.toURL().openStream();
                Assert.fail((String)"should have expired!");
            }
            catch (IOException e) {}
        }
    }

    @Override
    @BeforeClass(groups={"live"})
    public void setup() {
        super.setup();
        String key = UUID.randomUUID().toString();
        for (String regionId : ((SwiftApi)this.api).getConfiguredRegions()) {
            ((SwiftApi)this.api).getAccountApi(regionId).updateTemporaryUrlKey(key);
            ((SwiftApi)this.api).getContainerApi(regionId).create(this.containerName);
            ((SwiftApi)this.api).getObjectApi(regionId, this.containerName).put(this.name, (Payload)Payloads.newByteSourcePayload((ByteSource)ByteSource.wrap((byte[])"swifty".getBytes())));
        }
    }

    @AfterMethod
    @AfterClass(groups={"live"})
    public void tearDown() {
        for (String regionId : ((SwiftApi)this.api).getConfiguredRegions()) {
            ((SwiftApi)this.api).getObjectApi(regionId, this.containerName).delete(this.name);
            ((SwiftApi)this.api).getContainerApi(regionId).deleteIfEmpty(this.containerName);
        }
        super.tearDown();
    }
}

