/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.swift.v1;

import com.google.common.base.Charsets;
import com.squareup.okhttp.mockwebserver.MockResponse;
import com.squareup.okhttp.mockwebserver.MockWebServer;
import com.squareup.okhttp.mockwebserver.RecordedRequest;
import java.util.Properties;
import org.jclouds.openstack.swift.v1.SwiftApi;
import org.jclouds.openstack.swift.v1.features.AccountApiMockTest;
import org.jclouds.openstack.v2_0.internal.BaseOpenStackMockTest;
import org.testng.Assert;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

@Test
public class AuthenticationMockTest
extends BaseOpenStackMockTest<SwiftApi> {
    @DataProvider(name="jclouds.keystone.credential-type")
    Object[][] credentialTypeToPostBody() {
        Object[][] credentialTypeToPostBody = new Object[2][2];
        credentialTypeToPostBody[0][0] = "apiAccessKeyCredentials";
        credentialTypeToPostBody[0][1] = "{\"auth\":{\"apiAccessKeyCredentials\":{\"accessKey\":\"joe\",\"secretKey\":\"letmein\"},\"tenantName\":\"jclouds\"}}";
        credentialTypeToPostBody[1][0] = "passwordCredentials";
        credentialTypeToPostBody[1][1] = "{\"auth\":{\"passwordCredentials\":{\"username\":\"joe\",\"password\":\"letmein\"},\"tenantName\":\"jclouds\"}}";
        return credentialTypeToPostBody;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(dataProvider="jclouds.keystone.credential-type")
    public void authenticateCredentialType(String credentialType, String expectedPost) throws Exception {
        MockWebServer server = AuthenticationMockTest.mockOpenStackServer();
        server.enqueue(this.addCommonHeaders(new MockResponse().setBody(this.stringFromResource("/access.json"))));
        server.enqueue(this.addCommonHeaders(AccountApiMockTest.accountResponse()));
        try {
            Properties overrides = new Properties();
            overrides.setProperty("jclouds.keystone.credential-type", credentialType);
            SwiftApi api = (SwiftApi)this.api(server.getUrl("/").toString(), "openstack-swift", overrides);
            api.getAccountApi("DFW").get();
            Assert.assertEquals((int)server.getRequestCount(), (int)2);
            RecordedRequest authRequest = server.takeRequest();
            Assert.assertEquals((String)authRequest.getRequestLine(), (String)"POST /tokens HTTP/1.1");
            Assert.assertEquals((String)new String(authRequest.getBody(), Charsets.UTF_8), (String)expectedPost);
        }
        finally {
            server.shutdown();
        }
    }
}

