/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.keystone.auth.filters;

import com.google.common.base.Supplier;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import org.jclouds.http.HttpException;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.HttpRequestFilter;
import org.jclouds.openstack.keystone.auth.config.Authentication;

@Singleton
public class AuthenticateRequest
implements HttpRequestFilter {
    private final Supplier<String> authTokenProvider;

    @Inject
    AuthenticateRequest(@Authentication Supplier<String> authTokenProvider) {
        this.authTokenProvider = authTokenProvider;
    }

    public HttpRequest filter(HttpRequest request) throws HttpException {
        return ((HttpRequest.Builder)request.toBuilder().replaceHeader("X-Auth-Token", new String[]{(String)this.authTokenProvider.get()})).build();
    }
}

