/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.glacier.options;

import com.google.common.base.Preconditions;
import org.jclouds.http.options.BaseHttpRequestOptions;

public class PaginationOptions
extends BaseHttpRequestOptions {
    private static final int MIN_LIMIT = 1;
    private static final int MAX_LIMIT = 1000;

    public PaginationOptions marker(String marker) {
        this.queryParameters.put((Object)"marker", (Object)((String)Preconditions.checkNotNull((Object)marker, (Object)"marker")));
        return this;
    }

    public PaginationOptions limit(int limit) {
        Preconditions.checkArgument((limit >= 1 ? 1 : 0) != 0, (Object)("limit must be >= 1 but was " + limit));
        Preconditions.checkArgument((limit <= 1000 ? 1 : 0) != 0, (Object)("limit must be <= 1000 but was " + limit));
        this.queryParameters.put((Object)"limit", (Object)Integer.toString(limit));
        return this;
    }

    public static class Builder {
        public static PaginationOptions marker(String marker) {
            PaginationOptions options = new PaginationOptions();
            return options.marker(marker);
        }

        public static PaginationOptions limit(int limit) {
            PaginationOptions options = new PaginationOptions();
            return options.limit(limit);
        }
    }
}

