/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.glacier.domain;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.gson.annotations.SerializedName;
import java.beans.ConstructorProperties;
import org.jclouds.glacier.domain.JobRequest;
import org.jclouds.glacier.util.ContentRange;
import org.jclouds.javax.annotation.Nullable;

public class ArchiveRetrievalJobRequest
extends JobRequest {
    private static final String TYPE = "archive-retrieval";
    @SerializedName(value="ArchiveId")
    private final String archiveId;
    @SerializedName(value="Description")
    private final String description;
    @SerializedName(value="RetrievalByteRange")
    private final ContentRange range;

    private ArchiveRetrievalJobRequest(String archiveId, @Nullable String description, @Nullable ContentRange range) {
        super(TYPE);
        this.archiveId = (String)Preconditions.checkNotNull((Object)archiveId, (Object)"archiveId");
        this.description = description;
        this.range = range;
    }

    @ConstructorProperties(value={"ArchiveId", "Description", "RetrievalByteRange"})
    private ArchiveRetrievalJobRequest(String archiveId, @Nullable String description, @Nullable String range) {
        this(archiveId, description, range == null ? null : ContentRange.fromString(range));
    }

    public String getDescription() {
        return this.description;
    }

    public ContentRange getRange() {
        return this.range;
    }

    public String getArchiveId() {
        return this.archiveId;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.archiveId, this.description, this.range});
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ArchiveRetrievalJobRequest other = (ArchiveRetrievalJobRequest)obj;
        return Objects.equal((Object)this.archiveId, (Object)other.archiveId) && Objects.equal((Object)this.description, (Object)other.description) && Objects.equal((Object)this.range, (Object)other.range);
    }

    public String toString() {
        return "InventoryRetrievalParameters [archiveId=" + this.archiveId + ", description=" + this.description + ", range=" + this.range + "]";
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private String archiveId;
        private String description;
        private ContentRange range;

        Builder() {
        }

        public Builder archiveId(String archiveId) {
            this.archiveId = archiveId;
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            return this;
        }

        public Builder range(ContentRange range) {
            this.range = range;
            return this;
        }

        public ArchiveRetrievalJobRequest build() {
            return new ArchiveRetrievalJobRequest(this.archiveId, this.description, this.range);
        }
    }
}

