/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.glacier.binders;

import com.google.common.base.Preconditions;
import java.io.IOException;
import org.jclouds.glacier.util.TreeHash;
import org.jclouds.http.HttpException;
import org.jclouds.http.HttpRequest;
import org.jclouds.io.Payload;
import org.jclouds.rest.Binder;

public class BindHashesToHeaders
implements Binder {
    private HttpRequest addChecksumHeaders(HttpRequest request, Payload payload) {
        try {
            TreeHash hash = TreeHash.buildTreeHashFromPayload(payload);
            request = ((HttpRequest.Builder)((HttpRequest.Builder)request.toBuilder().addHeader("x-amz-content-sha256", new String[]{hash.getLinearHash().toString()})).addHeader("x-amz-sha256-tree-hash", new String[]{hash.getTreeHash().toString()})).build();
        }
        catch (IOException e) {
            throw new HttpException("Error hashing the payload", (Throwable)e);
        }
        return request;
    }

    public <R extends HttpRequest> R bindToRequest(R request, Object input) {
        Preconditions.checkArgument((boolean)(input instanceof Payload), (Object)"This binder is only valid for Payload");
        Preconditions.checkNotNull(request, (Object)"request");
        Payload payload = (Payload)Payload.class.cast(input);
        return (R)this.addChecksumHeaders(request, payload);
    }
}

