/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudwatch.internal;

import com.google.common.base.Function;
import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.inject.Module;
import java.net.URI;
import java.util.Map;
import org.jclouds.cloudwatch.config.CloudWatchHttpApiModule;
import org.jclouds.date.DateService;
import org.jclouds.location.config.LocationModule;
import org.jclouds.location.suppliers.RegionIdToURISupplier;
import org.jclouds.rest.ConfiguresHttpApi;
import org.jclouds.rest.internal.BaseRestApiExpectTest;
import org.jclouds.util.Suppliers2;

public class BaseCloudWatchExpectTest<T>
extends BaseRestApiExpectTest<T> {
    public BaseCloudWatchExpectTest() {
        this.provider = "cloudwatch";
    }

    protected Module createModule() {
        return new TestMonitoringHttpApiModule();
    }

    @ConfiguresHttpApi
    private static final class TestMonitoringHttpApiModule
    extends CloudWatchHttpApiModule {
        private TestMonitoringHttpApiModule() {
        }

        protected void installLocations() {
            this.install((Module)new LocationModule());
            this.bind(RegionIdToURISupplier.class).toInstance((Object)new RegionIdToURISupplier(){

                public Map<String, Supplier<URI>> get() {
                    return Maps.transformValues((Map)ImmutableMap.of((Object)"eu-west-1", (Object)URI.create("https://ec2.eu-west-1.amazonaws.com"), (Object)"us-east-1", (Object)URI.create("https://ec2.us-east-1.amazonaws.com"), (Object)"us-west-1", (Object)URI.create("https://ec2.us-west-1.amazonaws.com")), (Function)Suppliers2.ofInstanceFunction());
                }
            });
        }

        protected String provideTimeStamp(DateService dateService) {
            return "2009-11-08T15:54:08.897Z";
        }
    }
}

