/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudwatch.options;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.Date;
import org.jclouds.cloudwatch.domain.HistoryItemType;
import org.jclouds.cloudwatch.options.ListAlarmHistoryOptions;
import org.jclouds.date.DateService;
import org.jclouds.date.internal.SimpleDateFormatDateService;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"})
public class ListAlarmHistoryOptionsTest {
    private DateService dateService = new SimpleDateFormatDateService();

    public void testEmptyOptions() throws Exception {
        Multimap formParameters = new ListAlarmHistoryOptions().buildFormParameters();
        Assert.assertFalse((boolean)formParameters.containsKey((Object)"AlarmName"));
        Assert.assertFalse((boolean)formParameters.containsKey((Object)"EndDate"));
        Assert.assertFalse((boolean)formParameters.containsKey((Object)"HistoryItemType"));
        Assert.assertFalse((boolean)formParameters.containsKey((Object)"MaxRecords"));
        Assert.assertFalse((boolean)formParameters.containsKey((Object)"NextToken"));
        Assert.assertFalse((boolean)formParameters.containsKey((Object)"StartDate"));
    }

    public void testPopulatedOptions() throws Exception {
        String alarmName = "TestAlarmName";
        Date endDate = new Date(new Date().getTime() + 5000L);
        HistoryItemType historyItemType = HistoryItemType.ACTION;
        int maxRecords = 5;
        Date startDate = new Date();
        Multimap formParameters = new ListAlarmHistoryOptions().alarmName(alarmName).endDate(endDate).historyItemType(historyItemType).maxRecords(maxRecords).startDate(startDate).buildFormParameters();
        Assert.assertEquals((Collection)formParameters.get((Object)"AlarmName"), (Collection)ImmutableSet.of((Object)alarmName));
        Assert.assertEquals((Collection)formParameters.get((Object)"EndDate"), (Collection)ImmutableSet.of((Object)this.dateService.iso8601DateFormat(endDate)));
        Assert.assertEquals((Collection)formParameters.get((Object)"HistoryItemType"), (Collection)ImmutableSet.of((Object)historyItemType.toString()));
        Assert.assertEquals((Collection)formParameters.get((Object)"MaxRecords"), (Collection)ImmutableSet.of((Object)Integer.toString(maxRecords)));
        Assert.assertEquals((Collection)formParameters.get((Object)"StartDate"), (Collection)ImmutableSet.of((Object)this.dateService.iso8601DateFormat(startDate)));
    }
}

